<?php

namespace Cms\Client\CmsUser\Model;

use Cms\LinkResource\AbstractLinkResourceModel;
use Cms\LinkResource\FlattenResourcesAwareInterface;
use Cms\LinkResource\FlattenResourcesTrait;
use Cms\Model\CmsUser\CmsUserModel;
use Cms\Model\CmsUser\CmsUserProfil;
use Cms\Model\CmsUser\LinkResource\LinkResourceModel;

/**
 * Class CmsUserRestfulModel
 * @package Cms\Client\CmsUser\Model
 * @property array $scopes
 * @property array $profiles
 * @property string $password
 * @property string $update_password
 * @property bool $ask_reset_password
 */
class CmsUserRestfulModel extends CmsUserModel implements
    FlattenResourcesAwareInterface
{
    use FlattenResourcesTrait;

    /** @var  array */
    protected $scopes;

    /** @var  array */
    protected $profiles;

    /** @var  string */
    protected $password;

    /** @var  string */
    protected $update_password;

    /** @var  bool */
    protected $ask_reset_password;

    /**
     * @param int $scopeId
     * @param string|CmsUserProfil $profil
     * @throws \InvalidArgumentException
     */
    public function addProfilForScope(int $scopeId, $profil)
    {
        if (empty($profil) || !CmsUserProfil::isValid($profil)) {
            throw new \InvalidArgumentException('profil invalide');
        }
        $this->profiles[$scopeId] = (string)$profil;
    }

    /**
     * @param AbstractLinkResourceModel|array $resourceData
     * @return LinkResourceModel
     */
    public function handleResource($resourceData)
    {
        if (!$resourceData instanceof LinkResourceModel) {
            $resourceData = (new LinkResourceModel())->populate($resourceData, true);
        }
        return $resourceData;
    }
}
