<?php


namespace Cms\Client\Service;

/**
 * Trait GeodataServiceAwareTrait
 * @package Cms\Client\Service
 */
trait GeodataServiceAwareTrait
{

    /** @var  \Cms\Client\Service\GeodataService */
    protected $geodataService;

    /**
     * @param \Cms\Client\Service\GeodataService $geodataService
     * @return $this
     */
    public function setGeodataService(GeodataService $geodataService)
    {
        $this->geodataService = $geodataService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\GeodataService
     * @throws \DomainException
     */
    public function getGeodataService() : GeodataService
    {
        if (!$this->geodataService instanceof GeodataService) {
            throw new \DomainException('geodataService is not a GeodataService instance');
        }
        return $this->geodataService;
    }
}
