<?php


namespace Cms\Extension\MediaHandler;

use Cms\Client\AssetConfigRelationRestfulModel;
use League\Plates\Template\Template;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class AbstractMediaHandlerComponent
 * @package Cms\Extension\MediaHandler
 */
abstract class AbstractMediaHandlerComponent extends AbstractMediaHandler
{

    /** @var Template */
    protected $template;

    /**
     * MediaHandlerImage constructor.
     * @param Template $template
     */
    public function __construct(Template $template)
    {
        $this->template = $template;
    }

    /**
     * @param Template $template
     * @param AssetConfigRelationRestfulModel $assetModel
     * @param array $handlerConfig
     */
    protected function assignData(
        Template $template,
        AssetConfigRelationRestfulModel $assetModel,
        array $handlerConfig = []
    ) {
        // assign des données de config et d'asset
        $template->data($handlerConfig);
        $template->data([
            'asset' => (new ObjectTransformer())->transform($assetModel),
        ]);
    }

    /**
     * @param AssetConfigRelationRestfulModel $assetModel
     * @param array $handlerConfig
     * @return string
     */
    final protected function renderMedia(
        AssetConfigRelationRestfulModel $assetModel,
        array $handlerConfig = []
    ) {
        // chargement des données lié au composant
        $this->assignData($this->template, $assetModel, $handlerConfig);

        // rendu du template
        return $this->template->render();
    }
}
