<?php

namespace Cms\Bundle\Newsletter;

use Cms\Client\Service\MemberService;
use Cms\Route\AbstractRoute;
use League\Route\Strategy\JsonStrategy;

/**
 * Class NewsletterRoute
 * @package Cms\Bundle\Newsletter
 */
class NewsletterRoute extends AbstractRoute
{

    /** @var array */
    protected $routes = [
        'record' => '/newsletter/record',
        'confirm' => '/newsletter/confirm',
    ];

    /** @var string  */
    protected $className;
    /** @var array */
    private $classDeps;

    /**
     * NewsletterRoute constructor.
     * @param string $className
     * @param array $classDeps
     */
    public function __construct($className = NewsletterController::class, array $classDeps = [])
    {
        $this->className = $className;
        $this->classDeps = $classDeps;
    }

    /**
     * @return void
     */
    public function register()
    {
        // ajoute le controller
        $this->container->add($this->className)
            ->withArguments(array_merge([
                MemberService::class,
            ], $this->classDeps));

        // ajoutes les routes
        $this->addPageRoute('record', $this->className, 'POST', 'record')
            ->setStrategy(new JsonStrategy());
        $this->addPageRoute('confirm', $this->className, 'GET', 'confirm');
    }
}
