<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\ProductRestfulModel;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Campsite\Product\ProductFieldFlagSet;
use Move\Http\Client\HttpClientInterface;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class ProductClient
 * @package Cms\Client\Campsite
 */
class ProductClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/product';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * FeatureClient constructor.
     * @param HttpClientInterface $client
     */
    public function __construct(HttpClientInterface $client)
    {
        $transformer = new ObjectTransformer();
        $transformer->modify('field_flag', function ($fieldFlag) {
            if ($fieldFlag instanceof ProductFieldFlagSet) {
                return $fieldFlag->getArrayCopy();
            }
            return $fieldFlag;
        });
        $transformer->modify('field_flag_package', function ($fieldFlag) {
            if ($fieldFlag instanceof ProductFieldFlagSet) {
                return $fieldFlag->getArrayCopy();
            }
            return $fieldFlag;
        });
        parent::__construct($client, $transformer);
    }

    /**
     * @param array $dataset
     * @return ProductRestfulModel
     */
    public function handleData($dataset = []) : ProductRestfulModel
    {
        return (new ProductRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ProductRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $code
     * @return mixed|null
     */
    public function getProductByCode(string $code)
    {
        $builder = $this->getBuilder();
        $builder->setFilter('code', $code);

        return $builder->getIndex(-1)->getFirst();
    }
}
