<?php

namespace Cms\Model\Asset;

use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class AssetValidator
 * @package Cms\Model\Asset
 */
class AssetValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'mime' => true,
            'profil' => new EnumSpecification(AssetProfil::class),
        ]);
        $myFilter->modify('profil', function ($state) {
            return (string)$state;
        });

        return $myFilter;
    }
}
