<?php

namespace Cms\Search\Campsite\Transformer;

use Cms\Bundle\Helper\CampsiteHelper;
use Cms\LinkResource\LinkResourcePrefsIdentifier;
use Cms\Search\ResultElementInterface;
use Cms\Transformer\Decorator\AbstractTransformerDecorator;

/**
 * Class CampsiteResultTransformer
 * @package Cms\Search\Campsite\Transformer
 */
class CampsiteResultTransformer extends AbstractTransformerDecorator
{

    /** @var bool */
    private $includeSource;

    /**
     * CampsiteResultTransformer constructor.
     * @param bool $includeSource
     */
    public function __construct(bool $includeSource = true)
    {
        $this->includeSource = $includeSource;
    }

    /**
     * @param \Cms\Search\ResultElementInterface $element
     * @return array
     * @throws \UnexpectedValueException
     * @throws \InvalidArgumentException
     */
    public function transformToArray($element) : array
    {
        if (!$element instanceof ResultElementInterface) {
            throw new \InvalidArgumentException('object must be a ResultElementInterface object');
        }

        $source = $element->getSource();

        // lecture des donnée address
        $cityName = $deptCode = $cityCp = $cityRoad = $gpsLoc = $countryCode = null;
        foreach ($source['addresses_nested'] ?? [] as $address) {
            if ($address['type'] === LinkResourcePrefsIdentifier::ADDRESS_LOC) {
                $cityName = $address['city_name'];
                $cityCp = $address['postal_code'];
                $countryCode = $address['country_code'];
                $deptCode = $address['admin2_code'];
                $cityRoad = $address['address1'];
                if (!empty($address['geo_location'])) {
                    $gpsLoc = $address['geo_location'];
                }
                break;
            }
        }

        // récuperation du classement du campings
        [$nbetoile, $isPRL, $isFFCC] = CampsiteHelper::getCampsiteClassement(
            $source['features_nested'] ?? []
        );

        $dataset = [
            'id' => $element->getId(),
            'name' => $source['campsite_name'],
            'gps_location' => $gpsLoc,
            'admin_code' => $deptCode,
            'country_code' => $countryCode,
            'city_name' => $cityName,
            'city_cp' => $cityCp,
            'city_road' => $cityRoad,
            'is_ffcc' => $isFFCC,
            'classmnt' => $nbetoile,
            'classmnt_prl' => $isPRL,
        ];
        if ($this->includeSource) {
            $dataset = array_merge($source, $dataset);
        }

        return $dataset;
    }
}
