<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\MultiRegexParser;

/**
 * Class Vimeo
 * @package Embed\AdapterProvider
 */
class Vimeo extends AbstractAdapterProvider
{

    /**
     * @return Oembed
     */
    public function getAdapter()
    {
        $oembed = new Oembed('http://vimeo.com/api/oembed.json');
        return $oembed;
    }

    /**
     * @inheritdoc
     */
    public function getParser()
    {
        $regexParser = new MultiRegexParser([
            '@^(?:https?://)?(?:www\.)?vimeo\.com/groups/[^/]+/videos/(.*)$@',
            '@^(?:https?://)?(?:www\.)?vimeo\.com/channels/[^/]+/(.*)$@',
            '@^(?:https?://)?(?:www\.)?vimeo\.com/(.*)$@',
        ]);
        return $regexParser;
    }
}
