<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;
use Move\Embed\Normalizer\YoutubeNormalizer;
use Move\Embed\Parser\RegexParser;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class OembedTest
 * @package Move\Embed\Adapter
 */
class OembedTest extends TestCase
{
    /**
     * @covers Oembed::__construct
     * @return Oembed
     */
    public function testConstruct()
    {
        $endPoint = 'endpoint';
        $expectedParam = [
            'format' => 'json',
            'xxx' => 'yyy'
        ];
        $instance = new Oembed($endPoint, ['xxx' => 'yyy']);
        $this->assertInstanceOf(Oembed::class, $instance);

        $this->assertEquals(
            $endPoint,
            Reflection::getValue($instance, 'endpoint')
        );

        $this->assertEquals(
            $expectedParam,
            Reflection::getValue($instance, 'defaultParams')
        );

        return $instance;
    }

    /**
     * @param Oembed $instance
     * @depends testConstruct
     */
    public function testSetNormailzer(Oembed $instance)
    {
        /** @var RegexParser $parser */
        $parser = $this
            ->getMockBuilder(RegexParser::class)
            ->setConstructorArgs(['/[0-9]+/'])
            ->getMock();

        /** @var YoutubeNormalizer $normalizer */
        $normalizer = $this
            ->getMockBuilder(YoutubeNormalizer::class)
            ->setConstructorArgs([$parser])
            ->getMock();

        $instance->setNormalizer($normalizer);
        $this->assertEquals(
            $normalizer,
            Reflection::getValue($instance, 'normalizer')
        );
    }

    /**
     * @depends testConstruct
     */
    public function testNormalizeUriWithoutNormalizer()
    {
        $instance = new Oembed('test', ['xxx' => 'yyy']);
        $uri = 'testUri';
        $this->assertEquals($uri, $instance->normalizeUri($uri));
    }

    /**
     * @depends testConstruct
     * @covers Oembed::getEmbedModel
     */
    public function testGetEmbedModel()
    {
        /** @var Oembed|\PHPUnit_Framework_MockObject_MockObject $instance */
        $instance = $this
            ->getMockBuilder(Oembed::class)
            ->setConstructorArgs(['test', ['xxx' => 'yyy']])
            ->setMethods(['call'])
            ->getMock();

        $instance->expects($this->any())
            ->method('call')
            ->willReturn([
                'type' => 'photo',
                'url' => 'http://imageurl',
                'width' => 100,
                'height' => 100
            ]);
        $embed = $instance->getEmbedModel('default/index', []);
        $this->assertInstanceOf(EmbedModel::class, $embed);

        $this->assertNotEmpty(Reflection::getValue($embed, 'html'));
        $this->assertNotEmpty(Reflection::getValue($embed, 'source_url'));
    }

    /**
     * @depends testConstruct
     */
    public function testGetEmbedModelReturnNull()
    {
        /** @var Oembed|\PHPUnit_Framework_MockObject_MockObject $instance */
        $instance = $this
            ->getMockBuilder(Oembed::class)
            ->setConstructorArgs(['test', ['xxx' => 'yyy']])
            ->setMethods(['call'])
            ->getMock();

        $instance
            ->expects($this->any())
            ->method('call')
            ->willReturn([
                'type' => 'undefined',
                'url' => 'http://imageurl',
                'width' => 100,
                'height' => 100
            ]);

        $embed = $instance->getEmbedModel('default/index', []);
        $this->assertNull($embed);
    }
}
