<?php

namespace Move\Http\Strategy;

use Interop\Container\ContainerInterface;
use Move\Http\Strategy\Handler\HandlerServiceInterface;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class FormatStrategyTest
 * @package Move\Http\Strategy
 */
class FormatStrategyTest extends TestCase
{

    /**
     * @return HandlerServiceInterface|\PHPUnit_Framework_MockObject_MockObject
     */
    private function getHandlerMockObject()
    {
        $handler = $this->getMockBuilder(HandlerServiceInterface::class)
            ->getMock();
        $responseInterface = $this->getMockBuilder(ResponseInterface::class)
            ->getMock();

        $handler->expects($this->any())
            ->method('handleException')
            ->willReturn($responseInterface);

        return $handler;
    }
    /**
     * @covers FormatStrategy::__construct
     */
    public function testConstruct()
    {
        $handler = $this->getHandlerMockObject();
        $instance = new FormatStrategy([$handler]);
        $this->assertInstanceOf(FormatStrategy::class, $instance);
        return $instance;
    }

    /**
     * @depends testConstruct
     * @covers FormatStrategy::handlerRequirePolicy
     * @param $strategy
     */
    public function testHandlerRequirePolicy(FormatStrategy $strategy)
    {
        $strategy->handlerRequirePolicy('dummyPlicy');
    }

    /**
     * @depends testConstruct
     * @param FormatStrategy $strategy
     *
     * @throws \Exception
     */
    public function testDispatch(FormatStrategy $strategy)
    {
        /** @var ContainerInterface $mockContainer */
        $mockContainer = $this->getMockBuilder(ContainerInterface::class)
            ->getMock();
        $strategy->setContainer($mockContainer);

        // Set a mock request
        $mockRequest = $this->getMockBuilder(ServerRequestInterface::class)
            ->getMock();
        $strategy->setRequest($mockRequest);

        // set a mock response
        $mockResponse = $this->getMockBuilder(ResponseInterface::class)
            ->getMock();
        $strategy->setResponse($mockResponse);

        $response = $strategy->dispatch(
            function (){},
            []
        );

        $this->assertInstanceOf(ResponseInterface::class, $response);
    }

    /**
     * @depends testConstruct
     * @param FormatStrategy $strategy
     */
    public function testSetHandlerFallback(FormatStrategy $strategy)
    {
        $handler = $this->getMockBuilder(HandlerServiceInterface::class)
            ->getMock();
        $instance = $strategy->setHandlerFallback($handler);
        $this->assertInstanceOf(FormatStrategy::class, $instance);
    }

    /**
     * @depends testConstruct
     * @param FormatStrategy $strategy
     */
    public function testAddHandler(FormatStrategy $strategy)
    {
        $handler = $this->getMockBuilder(HandlerServiceInterface::class)
            ->getMock();

        $strategy->addHandler($handler);
    }
}
