<?php

namespace Cms\Client\Article\Helper;

use Cms\Client\Article\Model\ArticleRestfulModel;
use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Client\Command\Article\Command\FetchArticleCategoryCommand;
use Cms\Client\Command\Article\Command\FetchArticleCommand;
use Cms\Client\Command\CommandExecutorHelper;
use Cms\Client\Command\ExceptionDecoratorInterface;
use Cms\Client\Service\ArticleService;

/**
 * Trait ArticleHelperTrait
 * @package Cms\Client\Article\Helper
 */
trait ArticleHelperTrait
{

    /**
     * @return \Cms\Client\Service\ArticleService
     */
    abstract public function getArticleService() : ArticleService;

    /**
     * @param string|int $identifier Category slug or id
     * @param int|null $scopeId obligatoire si slug comme $identifier
     * @param \Cms\Client\Command\ExceptionDecoratorInterface|null $decorator
     * @param int|null $slugLevel
     * @return \Cms\Client\Article\Model\CategoryRestfulModel
     * @throws \Move\Command\Exception\CommandException
     */
    protected function getCategoryModel(
        $identifier,
        int $scopeId = null,
        ExceptionDecoratorInterface $decorator = null,
        int $slugLevel = null
    ) : CategoryRestfulModel {
        // récuperaiton du bus
        $commandBus = $this->getArticleService()->getCategoryCommandBus();

        // creation de la commande
        $command = new FetchArticleCategoryCommand();
        $command->setScopeId($scopeId);
        if (is_numeric($identifier)) {
            $command = $command->withId($identifier);
        } else {
            $command->setSlug($identifier);
            if ($slugLevel !== null) {
                $command->setSlugLevel($slugLevel);
            }
        }

        // execution
        $categoryModel = CommandExecutorHelper::handleCmd(
            $commandBus,
            $command,
            $decorator
        );
        return $categoryModel;
    }


    /**
     * @param string|int $identifier Article slug or id
     * @param int|null $scopeId obligatoire si slug comme $identifier
     * @param \Cms\Client\Command\ExceptionDecoratorInterface|null $decorator
     * @return \Cms\Client\Article\Model\ArticleRestfulModel
     * @throws \Move\Command\Exception\CommandException
     */
    protected function getArticeModel(
        $identifier,
        int $scopeId = null,
        ExceptionDecoratorInterface $decorator = null
    ) : ArticleRestfulModel {
        $commandBus = $this->getArticleService()->getArticleCommandBus();

        $command = new FetchArticleCommand();
        $command->setScopeId($scopeId);
        if (is_numeric($identifier)) {
            $command = $command->withId($identifier);
        } else {
            $command->setSlug($identifier);
        }

        // execution
        $articleModel = CommandExecutorHelper::handleCmd(
            $commandBus,
            $command,
            $decorator
        );
        return $articleModel;
    }
}
