<?php

namespace Cms\Client\Campsite\Transformer;

use Cms\Client\Campsite\Model\ProductRestfulModel;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class ProductTransformer
 * @package Cms\Client\Campsite\Transformer
 */
class ProductTransformer extends ObjectTransformer
{

    /**
     * @param \Cms\Client\Campsite\Model\ProductRestfulModel|DomainObjectInterface $object
     * @return array
     */
    public function transform(DomainObjectInterface $object) : array
    {
        $result = parent::transform($object);
        if (!$object instanceof ProductRestfulModel) {
            return $result;
        }

        // ajoute les code de traduction
        $result['i18n'] = array_map(new ObjectTransformer(), $object->i18n ?: []);

        if ($object->field_flag) {
            $result['field_flag'] = $object->field_flag->getArrayCopy();
        }
        if ($object->field_flag_package) {
            $result['field_flag_package'] = $object->field_flag_package->getArrayCopy();
        }
        return $result;
    }
}
