<?php

namespace Cms\Client\Command;

use Move\Command\Exception\NotFoundException;
use Move\Http\Client\Exception\HttpRequestException;

/**
 * Trait ExceptionDecoratorAwareTrait
 * @package Cms\Client\Command
 */
trait ExceptionDecoratorAwareTrait
{

    /** @var  \Cms\Client\Command\ExceptionDecoratorInterface */
    protected $exceptionDecorator;

    /**
     * @param \Cms\Client\Command\ExceptionDecoratorInterface $exceptionDecorator
     * @return $this
     */
    public function setExceptionDecorator(
        ExceptionDecoratorInterface $exceptionDecorator
    ) {
        $this->exceptionDecorator = $exceptionDecorator;
        return $this;
    }

    /**
     * @return \Cms\Client\Command\ExceptionDecoratorInterface
     * @throws \DomainException
     */
    protected function getExceptionDecorator() : ExceptionDecoratorInterface
    {
        if (!$this->exceptionDecorator instanceof ExceptionDecoratorInterface) {
            throw new \DomainException('exceptionDecorator must be an ExceptionDecoratorInterface');
        }
        return $this->exceptionDecorator;
    }

    /**
     * @param \Move\Http\Client\Exception\HttpRequestException $error
     * @return callable
     * @throws \DomainException
     */
    protected function getHttpRequestDecorator(HttpRequestException $error) : callable
    {
        return $this->getExceptionDecorator()->getHttpRequestDecorator($error);
    }

    /**
     * @param \Move\Command\Exception\NotFoundException $error
     * @return callable
     * @throws \DomainException
     */
    protected function getNotFoundDecorator(NotFoundException $error) : callable
    {
        return $this->getExceptionDecorator()->getNotFoundDecorator($error);
    }

    /**
     * @param \Throwable $error
     * @return callable
     * @throws \DomainException
     */
    protected function getThrowableDecorator(\Throwable $error) : callable
    {
        return $this->getExceptionDecorator()->getThrowableDecorator($error);
    }

    /**
     * @param \Throwable $error
     * @throws \DomainException
     */
    protected function handleThrowable(\Throwable $error)
    {
        if ($error instanceof HttpRequestException) {
            \call_user_func($this->getHttpRequestDecorator($error));
        } elseif ($error instanceof NotFoundException) {
            \call_user_func($this->getNotFoundDecorator($error));
        } else {
            \call_user_func($this->getThrowableDecorator($error));
        }
    }
}
