<?php


namespace Cms\Client\Service;

/**
 * Trait CmsScanServiceAwareTrait
 * @package Cms\Client\Service
 */
trait CmsScanServiceAwareTrait
{
    /** @var  \Cms\Client\Service\CmsScanService */
    protected $cmsScanService;

    /**
     * @param \Cms\Client\Service\CmsScanService $cmsScanService
     * @return $this
     */
    public function setCmsScanService(CmsScanService $cmsScanService)
    {
        $this->cmsScanService = $cmsScanService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\CmsScanService
     * @throws \DomainException
     */
    public function getCmsScanService() : CmsScanService
    {
        if (!$this->cmsScanService instanceof CmsScanService) {
            throw new \DomainException('cmsScanService is not a CmsScanService instance');
        }
        return $this->cmsScanService;
    }
}
