<?php

namespace Cms\Search;

use Cms\Search\Article\ArticleIndexFactory;
use Cms\Search\Campsite\CampsiteIndexFactory;
use Cms\Search\Contract\ContractIndexFactory;
use Elastica\Client;
use Move\Search\AbstractIndexFactory;
use Move\Search\Analyzer\FrenchHtmlTextAnalyzer;
use Move\Search\Analyzer\FrenchSearchAnalyzer;
use Move\Search\Analyzer\FrenchTextAnalyzer;
use Move\Search\Analyzer\GeoFrenchAnalyzer;
use Move\Search\Analyzer\GeoFrenchSearchAnalyzer;
use Move\Search\Analyzer\SearchWordAnalyzer;
use Move\Search\Analyzer\WordAnalyzer;
use Move\Search\ElasticIndexBuilder;
use Move\Search\ElasticIndexBuilderInterface;

/**
 * Class CmsIndexFactory
 * @package Cms\Search
 */
class CmsIndexFactory extends AbstractIndexFactory
{

    /** Nom generique de l'index dans es */
    public const INDEX_NAME = 'cmsdata';

    /**
     * CmsIndexFactory constructor.
     * @param \Elastica\Client $elasticaClient
     * @param array $mappingBuilders
     * @throws \InvalidArgumentException
     */
    public function __construct(Client $elasticaClient, array $mappingBuilders = [])
    {
        parent::__construct($elasticaClient, $mappingBuilders ?: [
            ContractIndexFactory::createMappingBuilder(),
            ArticleIndexFactory::createMappingBuilder(),
            CampsiteIndexFactory::createMappingBuilder(),
        ]);
    }

    /**
     * @param bool $recreate
     * @param int $shards
     * @return \Move\Search\ElasticIndexBuilder
     */
    public static function createIndexBuilder(
        bool $recreate = false,
        int $shards = null
    ) : ElasticIndexBuilderInterface {
        // calcul du nombre de replicas
        $replicas = (getenv('ELASTIC_CLUSTER_SIZE') ?: 1) - 1;

        // creation du builder
        $indexName = self::INDEX_NAME . '_' . date('dmY');
        $indexBuilder = new ElasticIndexBuilder($indexName, $shards ?? 2, $replicas ?: 2);
        if ($recreate === true) {
            $indexBuilder->forceRecreate();
        }

        // ajoute les analyzer
        $indexBuilder
            ->setAnalizer(new GeoFrenchAnalyzer())
            ->setAnalizer(new GeoFrenchSearchAnalyzer())
            ->setAnalizer(new WordAnalyzer())
            ->setAnalizer(new SearchWordAnalyzer())
            ->setAnalizer(new FrenchSearchAnalyzer())
            ->setAnalizer(new FrenchTextAnalyzer())
            ->setAnalizer(new FrenchHtmlTextAnalyzer());

        // creation de l'index
        return $indexBuilder;
    }

    /**
     * @return string
     */
    public static function getIndexName() : string
    {
        return self::INDEX_NAME;
    }
}
