<?php


namespace Cms\Seo;

use POM\DomainObjectAbstract;

/**
 * Class DescriptionBuilder
 * @package Cms\Seo
 */
class DescriptionBuilder extends AbstractSeoBuilder
{

    /**
     * @var string
     */
    protected $desc;

    /**
     * DescriptionBuilder constructor.
     * @param string $description
     */
    public function __construct($description = '')
    {
        $this->desc = $description;
    }

    /**
     * @param DomainObjectAbstract $model
     * @param string $attrName
     * @return $this
     */
    public function fallbackWithModel(DomainObjectAbstract $model, $attrName = 'seo_description')
    {
        $this->fallbackWithString($model[$attrName] ?? '');
        return $this;
    }

    /**
     * @param string $fallbackTitle
     * @return $this
     */
    public function fallbackWithString($fallbackTitle)
    {
        if (empty($fallbackTitle)) {
            $fallbackTitle = '';
        }
        $this->desc = $this->desc ?: $fallbackTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function render() : string
    {
        return $this->desc ?: '';
    }
}
