<?php


namespace Move\Http\Strategy\Serializer;

use League\Csv\CannotInsertRecord;
use League\Csv\Writer;
use Move\Http\Strategy\DataContainer\DataContainer;
use Psr\Http\Message\ResponseInterface;

/**
 * Class CsvLeagueSerializer
 * @package Move\Http\Strategy\Serializer
 */
class CsvLeagueSerializer implements SerializerInterface
{

    /**
     * @param mixed $container
     * @param ResponseInterface $response
     * @return string
     * @throws \InvalidArgumentException
     */
    public function serialize($container, ResponseInterface $response) : string
    {
        $dataset = $container;
        if ($container instanceof DataContainer) {
            $dataset = $container->getDataset();
        }
        if (!empty($dataset['data']) && \is_array($dataset['data'])) {
            try {
                $writer = Writer::createFromFileObject(new \SplTempFileObject());
                $writer->insertOne(array_keys($dataset['data'][0]));
                $writer->insertAll($dataset['data']);
            } catch (CannotInsertRecord $e) {
                throw new \RuntimeException('cannot write CSV : ' . $e->getMessage(), null, $e);
            }
            return $writer->getContent();
        }
        return \is_string($dataset) ? $dataset : '';
    }

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return string
     * @throws \InvalidArgumentException
     */
    public function __invoke($dataset, ResponseInterface $response)
    {
        return $this->serialize($dataset, $response);
    }
}
