<?php

namespace Move\ObjectMapper;

use POM\DomainObjectInterface;
use POM\Service\AdapterPdoAbstract;
use POM\Service\CursorPdo;

/**
 * Class RowToObjectHandleTrait
 * @package Move\ObjectMapper
 */
trait RowToObjectHandleTrait
{

    /**
     * @param string $sqlQuery
     * @param array $bind
     * @return \POM\Service\CursorPdo
     */
    protected function fetchAllQuery($sqlQuery, array $bind = []) : CursorPdo
    {
        $memberCursor = $this->getService()->fetch($sqlQuery, $bind);
        if (null !== $memberCursor) {
            $memberCursor->setRowHandler([$this, 'handleData']);
        }
        return $memberCursor;
    }

    /**
     * @param array $data
     * @return DomainObjectInterface
     */
    abstract public function handleData($data);

    /**
     * @return AdapterPdoAbstract
     */
    abstract public function getService();
}
