<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;
use Move\Embed\Parser\ParserInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class OembedFacebookTest
 * @package Move\Embed\Adapter
 */
class OembedFacebookTest extends TestCase
{
    /**
     * @covers OembedFacebook::__construct
     * @return OembedFacebook
     */
    public function testConstruct()
    {
        /** @var ParserInterface|\PHPUnit_Framework_MockObject_MockObject $parser */
        $parser = $this
            ->getMockBuilder(ParserInterface::class)
            ->setConstructorArgs([''])
            ->getMock();

        $instance = new OembedFacebook('endpoint', ['xxx' => 'yyy'], $parser);
        $this->assertInstanceOf(OembedFacebook::class, $instance);

        $this->assertEquals(
            $parser,
            Reflection::getValue($instance, 'parser')
        );

        return $instance;
    }

    /**
     * @covers OembedFacebook::getEmbedModel
     */
    public function testGetEmbedModel()
    {
        /** @var ParserInterface|\PHPUnit_Framework_MockObject_MockObject $parser */
        $parser = $this
            ->getMockBuilder(ParserInterface::class)
            ->setConstructorArgs([''])
            ->getMock();

        /** @var OembedFacebook|\PHPUnit_Framework_MockObject_MockObject $instance */
        $instance = $this
            ->getMockBuilder(OembedFacebook::class)
            ->setConstructorArgs(['test', ['xxx' => 'yyy'], $parser])
            ->setMethods(['call'])
            ->getMock();

        $instance->expects($this->any())
            ->method('call')
            ->willReturn([
                'type' => 'photo',
                'url' => 'http://imageurl',
                'width' => 100,
                'height' => 100
            ]);

        $embed = $instance->getEmbedModel('default/index', []);
        $this->assertInstanceOf(EmbedModel::class, $embed);

        $this->assertNotEmpty(Reflection::getValue($embed, 'html'));
        $this->assertNotEmpty(Reflection::getValue($embed, 'source_url'));
    }
}