<?php

namespace Move\Jato\Mapper;

use GuzzleHttp\Client;
use Move\Command\Exception\BadParameterException;
use Move\Http\Client\GuzzleClientAdapter;
use Move\Jato\JatoClient;
use Move\Jato\Model\SelectionFilterName;
use PHPUnit\Framework\TestCase;

/**
 * Class SelectionFilterMapperTest
 * @package Move\Jato\Mapper
 */
class SelectionFilterMapperTest extends TestCase
{
    /**
     * @return SelectionFilterMapper
     */
    public function testConstruct() : SelectionFilterMapper
    {
        $email = 'nlegall@movepublishing.com';
        $password = 'king7queen';

        $client = new JatoClient(
            new GuzzleClientAdapter(new Client(), 'webapi-live.jato.com/jato.carspecs.api'), $email,
            $password
        );

        $mapper = new SelectionFilterMapper($client);
        $clientTest = $mapper->getClient();

        $this->assertInstanceOf(JatoClient::class, $clientTest, 'Not a JatoClient');
        $this->assertEquals($client, $clientTest, 'Client not equal');

        return $mapper;
    }

    /**
     * @depends testConstruct
     * @param SelectionFilterMapper $mapper
     */
    public function testGetClient(SelectionFilterMapper $mapper)
    {
        $result = $mapper->getClient();
        $this->assertInstanceOf(JatoClient::class, $result, 'Not a JatoClient');
    }

    /**
     * @depends testConstruct
     * @param SelectionFilterMapper
     */
    public function testGetSelectionFilterList(SelectionFilterMapper $mapper)
    {
        $database = 'SSCF_CS2002';
        $filter = SelectionFilterName::BODY;
        $result = $mapper->getSelectionFilterList($database, $filter);

        $this->assertNotEmpty($result, 'result empty');
    }

    /**
     * @depends testConstruct
     * @param SelectionFilterMapper $mapper
     */
    public function testGetSelectionFilterListInvalid(SelectionFilterMapper $mapper)
    {
        $this->expectException(BadParameterException::class);

        $database = 'SSCF_CS2002';
        $filter = 'invalidFilter';
        $mapper->getSelectionFilterList($database, $filter);
    }

}