<?php


namespace Cms\Client\AddressBook\Transformer;

use Cms\Client\AddressBook\Model\AddressRestfulModel;
use Cms\Client\Geodata\Helper\GeodataTransformerTrait;
use Cms\Client\Service\GeodataService;
use Cms\Client\Service\GeodataServiceAwareTrait;
use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class AddressTransformer
 * @package Cms\Client\AddressBook\Transformer
 */
class AddressTransformer extends ObjectTransformer
{
    use GeodataServiceAwareTrait;
    use GeodataTransformerTrait;

    /**
     * AddressTransformer constructor.
     * @param GeodataService $geodataService
     */
    public function __construct(GeodataService $geodataService)
    {
        $this->setGeodataService($geodataService);
    }

    /**
     * @param AddressRestfulModel|DomainObjectInterface $object
     * @return array
     */
    public function transform(DomainObjectInterface $object)
    {
        $result = parent::transform($object);
        if (!$object instanceof AddressRestfulModel) {
            return $result;
        }

        // ajout de donnée d'attribut par clé/val
        $result['attrs'] = [];
        if (!empty($result['attributes'])) {
            foreach ($result['attributes'] as $attribute) {
                $result['attrs'][$attribute['name']] = $attribute['value'];
            }
        }

        // ajoute les donnée administrative
        $result['admin2'] = $this->transformAdminModel($object);
        if (empty($result['admin2'])) {
            $result['country'] = $this->transformCountryModel($object);
        } else {
            $result['country'] = $result['admin2']['country'];
        }

        return $result;
    }
}
