<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\GuideRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class CampsiteClient
 * @package Cms\Client\Campsite
 */
class GuideClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite/guide';

    /**
     * @param array $dataset
     * @return GuideRestfulModel
     */
    public function handleData($dataset = []) : Model\GuideRestfulModel
    {
        return (new GuideRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|GuideRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
