<?php


namespace Cms\Client\Service;

use Cms\Client\AddressBook\AddressBookAddressCategoryClient;
use Cms\Client\AddressBook\AddressBookAddressClient;
use Cms\Client\AddressBook\AddressBookClient;
use Cms\Client\AddressBook\AddressBookTripCategoryClient;
use Cms\Client\AddressBook\AddressBookTripClient;
use Move\ObjectMapper\ObjectTransformer;

/**
 * Class AddressBookService
 * @package Cms\Client\Service
 */
class AddressBookService
{
    /** @var AddressBookClient */
    private $addressBookClient;

    /** @var AddressBookTripClient */
    private $addressBookTripClient;

    /** @var AddressBookAddressClient */
    private $addressBookAddressClient;

    /** @var AddressBookTripCategoryClient */
    private $addressBookTripCategoryClient;

    /** @var ObjectTransformer */
    private $addressTransformer;

    /** @var ObjectTransformer */
    private $tripTransformer;

    /** @var AddressBookAddressCategoryClient */
    private $addressBookAddressCategoryClient;

    /**
     * AddressBookService constructor.
     * @param AddressBookClient $addressBookClient
     * @param AddressBookTripClient $addressBookTripClient
     * @param ObjectTransformer $tripTransformer
     * @param AddressBookAddressClient $addressBookAddressClient
     * @param ObjectTransformer $addressTransformer
     * @param AddressBookTripCategoryClient $addressBookTripCategoryClient
     * @param AddressBookAddressCategoryClient $addressBookAddressCategoryClient
     */
    public function __construct(
        AddressBookClient $addressBookClient,
        AddressBookTripClient $addressBookTripClient,
        ObjectTransformer $tripTransformer,
        AddressBookAddressClient $addressBookAddressClient,
        ObjectTransformer $addressTransformer,
        AddressBookTripCategoryClient $addressBookTripCategoryClient,
        AddressBookAddressCategoryClient $addressBookAddressCategoryClient
    ) {
        $this->addressBookClient = $addressBookClient;
        $this->addressBookTripClient = $addressBookTripClient;
        $this->tripTransformer = $tripTransformer;
        $this->addressBookAddressClient = $addressBookAddressClient;
        $this->addressTransformer = $addressTransformer;
        $this->addressBookTripCategoryClient = $addressBookTripCategoryClient;
        $this->addressBookAddressCategoryClient = $addressBookAddressCategoryClient;
    }

    /**
     * @return AddressBookClient
     */
    public function getAddressBookClient()
    {
        return $this->addressBookClient;
    }

    /**
     * @param AddressBookClient $addressBookClient
     * @return $this
     */
    public function setAddressBookClient($addressBookClient)
    {
        $this->addressBookClient = $addressBookClient;
        return $this;
    }

    /**
     * @return AddressBookTripClient
     */
    public function getAddressBookTripClient()
    {
        return $this->addressBookTripClient;
    }

    /**
     * @param AddressBookTripClient $addressBookTripClient
     * @return $this
     */
    public function setAddressBookTripClient($addressBookTripClient)
    {
        $this->addressBookTripClient = $addressBookTripClient;
        return $this;
    }

    /**
     * @return AddressBookAddressClient
     */
    public function getAddressBookAddressClient()
    {
        return $this->addressBookAddressClient;
    }

    /**
     * @param AddressBookAddressClient $addressBookAddressClient
     * @return AddressBookService
     */
    public function setAddressBookAddressClient($addressBookAddressClient)
    {
        $this->addressBookAddressClient = $addressBookAddressClient;
        return $this;
    }

    /**
     * @return AddressBookTripCategoryClient
     */
    public function getAddressBookTripCategoryClient()
    {
        return $this->addressBookTripCategoryClient;
    }

    /**
     * @param AddressBookTripCategoryClient $addressBookTripCategoryClient
     * @return $this
     */
    public function setAddressBookTripCategoryClient($addressBookTripCategoryClient)
    {
        $this->addressBookTripCategoryClient = $addressBookTripCategoryClient;
        return $this;
    }

    /**
     * @return ObjectTransformer
     */
    public function getAddressTransformer()
    {
        return $this->addressTransformer;
    }

    /**
     * @param ObjectTransformer $addressTransformer
     * @return $this
     */
    public function setAddressTransformer(ObjectTransformer $addressTransformer)
    {
        $this->addressTransformer = $addressTransformer;
        return $this;
    }

    /**
     * @return ObjectTransformer
     */
    public function getTripTransformer()
    {
        return $this->tripTransformer;
    }

    /**
     * @param ObjectTransformer $tripTransformer
     * @return $this
     */
    public function setTripTransformer($tripTransformer)
    {
        $this->tripTransformer = $tripTransformer;
        return $this;
    }

    /**
     * @return AddressBookAddressCategoryClient
     */
    public function getAddressBookAddressCategoryClient()
    {
        return $this->addressBookAddressCategoryClient;
    }

    /**
     * @param AddressBookAddressCategoryClient $addressBookAddressCategoryClient
     * @return $this
     */
    public function setAddressBookAddressCategoryClient($addressBookAddressCategoryClient)
    {
        $this->addressBookAddressCategoryClient = $addressBookAddressCategoryClient;
        return $this;
    }
}
