<?php


namespace Cms\Model\Asset\Config;

use Cms\Model\AbstractConfigModel;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;

/**
 * Class ConfigValidator
 * @package Cms\Model\Asset\Config
 */
class ConfigValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'asset_id' => FILTER_VALIDATE_INT,
            'config' => function ($config) {
                return $config instanceof AbstractConfigModel;
            },
        ]);

        return $myFilter;
    }
}
