<?php

namespace Cms\Model\Campsite\Product;

use Cms\Model\ScopeAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ProductModel
 * @package Cms\Model\Campsite\Product
 * @property int $id
 * @property string $code
 * @property string $name
 * @property string $description
 * @property string $help_desc
 * @property \Cms\Model\Campsite\CampsiteProductCategory $category
 * @property \Cms\Model\Campsite\Product\ProductFieldFlagSet $field_flag
 * @property \Cms\Model\Campsite\Product\ProductFieldFlagSet $field_flag_package
 * @property string $value_type
 */
class ProductModel extends DomainObjectAbstract
{
    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $code;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $description;

    /** @var  string */
    protected $help_desc;

    /** @var  \Cms\Model\Campsite\CampsiteProductCategory */
    protected $category;

    /** @var  \Cms\Model\Campsite\Product\ProductFieldFlagSet */
    protected $field_flag;

    /** @var  \Cms\Model\Campsite\Product\ProductFieldFlagSet */
    protected $field_flag_package;

    /** @var  string */
    protected $value_type;
}
