<?php
require_once __DIR__ . '/../vendor/autoload.php';

$jsonContent = <<<EOF
{"blocks":[{"key":"erkng","text":"Cat\u00e9gorie tr\u00e8s tendance en ce moment, le segment des petits SUV compte un absent de marque: Volkswagen. Mais nos photos espions prouvent que la marque allemande travaille activement \u00e0 r\u00e9parer cette lacune. On y d\u00e9couvre en effet un baroudeur au format bien plus compact que celui du Tiguan. Seul \u00e9l\u00e9ment bien visible \u00e0 travers l'important camouflage, la signature lumineuse des feux arri\u00e8re \u00e9voque d'ailleurs ce grand fr\u00e8re. Mais les lignes de ce SUV d\u00e9riv\u00e9 de la future Polo s'inspireront aussi du concept T-Cross Breeze du dernier salon de Gen\u00e8ve... m\u00eame s'il faudra faire l'impasse sur la possibilit\u00e9 de rouler \u00e0 ciel ouvert.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":206,"length":83,"style":"BOLD"},{"offset":552,"length":75,"style":"BOLD"}],"entityRanges":[{"offset":283,"length":6,"key":0},{"offset":464,"length":11,"key":1},{"offset":507,"length":14,"key":2}]},{"key":"15v6b","text":"Transmission int\u00e9grale sur les versions hautes","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"6vbat","text":"Avec ses 4,15 m de long environ, ce Volkswagen au nom encore myst\u00e9rieux viendra rivaliser avec les Renault Captur, Peugeot 2008 et autres Nissan Juke. Essentiellement propos\u00e9 en version deux roues motrices, il pourra aussi recevoir une transmission int\u00e9grale sur certaines motorisations, contrairement \u00e0 ses rivaux fran\u00e7ais. Pour ce faire, il reposera sur une \u00e9volution de la plate-forme MQB d\u00e9di\u00e9e sp\u00e9cialement aux petits mod\u00e8les. Quant \u00e0 la palette des motorisations, elle comprendra notamment le r\u00e9cent trois-cylindres 1.0 turbo-essence TSI de 110 ch, qui avait \u00e9t\u00e9 choisi par le concept T-Cross.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":207,"length":51,"style":"BOLD"},{"offset":340,"length":90,"style":"BOLD"}],"entityRanges":[{"offset":107,"length":6,"key":3},{"offset":123,"length":4,"key":4},{"offset":145,"length":4,"key":5}]},{"key":"3f6bv","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"72jht","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":6}]},{"key":"fbinl","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/volkswagen\/tiguan","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/14859-premieres-photos-pour-la-future-polo","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/actualites\/volkswagen\/volkswagen_t_cross_breeze","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/renault\/captur","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/peugeot\/2008","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/nissan\/juke","url_target":"_self"}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/2497\/config\/2454","link":"","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"automobile-magazine.fr","legend":"La prochaine g\u00e9n\u00e9ration de Polo sera accompagn\u00e9 d'un d\u00e9riv\u00e9\u00a8SUV, nettement plus ambitieux que l'actuelle CrossPolo qui n'est qu'une simple berline rehauss\u00e9e.","position":"full"}}],"html":null}
EOF;

// creation object
$dashContent = json_decode($jsonContent, true);
$content = new \Cms\DashParser\DashContent();
$content->setBlocks($dashContent['blocks']);
$content->setEntityMap($dashContent['entityMap']);

// test parse ok
if (!$content->getBlocks()) {
    throw new UnexpectedValueException("erreur de décodage : ");
}

// creation des handler par défault
$entityHandler = \Cms\DashParser\Entity\EntityHandlerFactory::createHandler();
$blockHandler = \Cms\DashParser\Block\BlockHandlerFactory::createHander();

// parse
$dash = \Cms\DashParser\DashParser::parse($content, $entityHandler, $blockHandler);

// serializer
$serializer = new \Cms\DashParser\Serializer\HtmlSerializer($dash->getEntityCollection());
echo $serializer->serialize($dash->getBlocksCollection());
echo "\n";