<?php


namespace Cms\DashParser;

/**
 * Class DashContent
 * @package Cms\DashParser
 */
class DashContent implements \JsonSerializable, DashContentInterface
{

    /** @var  array */
    protected $blocks;

    /** @var  array */
    protected $entityMap;

    /**
     * @return array
     */
    public function getBlocks()
    {
        return $this->blocks ?: [];
    }

    /**
     * @param array $blocks
     * @return $this
     */
    public function setBlocks($blocks)
    {
        $this->blocks = $blocks;
        return $this;
    }

    /**
     * @return array
     */
    public function getEntityMap()
    {
        return $this->entityMap ?: [];
    }

    /**
     * @param array $entityMap
     * @return $this
     */
    public function setEntityMap($entityMap)
    {
        $this->entityMap = $entityMap;
        return $this;
    }

    /**
     * @inheritdoc
     */
    public function jsonSerialize()
    {
        $dataset['entityMap'] = $this->getEntityMap();
        $dataset['blocks'] = $this->getBlocks();
        return $dataset;
    }
}