<?php


namespace Cms\DashParser;

use Cms\DashParser\Block\BlockHandlerFactory;
use Cms\DashParser\Entity\EntityHandlerFactory;
use Cms\DashParser\Serializer\HtmlSerializer;

/**
 * Class DashParserAwareTrait
 * @package Cms\DashParser
 */
trait DashParserAwareTrait
{

    /**
     * @param DashParser $parser
     * @return string
     */
    abstract protected function serializeParser(DashParser $parser);

    /**
     * @param DashContentInterface $content
     * @return DashParser
     */
    protected function parseContent($content)
    {
        $entityHandler = EntityHandlerFactory::createHandler();
        $blockHandler = BlockHandlerFactory::createHander();
        $parser = DashParser::parse($content, $entityHandler, $blockHandler);
        return $parser;
    }

    /**
     * @param DashContentInterface $content
     * @param string $defaultContent
     * @return HtmlSerializer|string
     */
    protected function serializeContent($content, $defaultContent = '')
    {
        if (!empty($content) && $content instanceof DashContentInterface) {
            if (!empty($content['html'])) {
                return $content['html'];
            } else {
                $parser = $this->parseContent($content);
                $htmlContent = $this->serializeParser($parser);
                return $htmlContent;
            }
        }
        return $defaultContent;
    }
}
