<?php

namespace Cms\DashParser\Entity;

use Cms\DashParser\AbstractHandler;

/**
 * Class AbstractEntityHandler
 * @package Cms\DashParser\Entity
 */
abstract class AbstractEntityHandler extends AbstractHandler
{

    /**
     * Check validity of entity for type
     * @param array $mapItem
     * @param string $type
     * @return bool
     */
    final protected function isValidEntity($mapItem, $type)
    {
        return is_array($mapItem)
        && !empty($mapItem['type'])
        && !empty($mapItem['data'])
        && $mapItem['type'] === strtoupper($type);
    }
}
