<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityEmbed
 * @package Cms\DashParser\Entity
 */
class EntityEmbed implements
    EntityBlockInterface
{

    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $thumbUrl;


    /**
     * EntityEmbed constructor.
     * @param string $url
     * @param string $thumbUrl
     */
    public function __construct($url, $thumbUrl)
    {
        $this->url = $url;
        $this->thumbUrl = $thumbUrl;
    }

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     * @return EntityEmbed
     */
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    /**
     * @return string
     */
    public function getThumbUrl()
    {
        return $this->thumbUrl;
    }

    /**
     * @param string $thumbUrl
     * @return EntityEmbed
     */
    public function setThumbUrl($thumbUrl)
    {
        $this->thumbUrl = $thumbUrl;
        return $this;
    }
}
