<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityImageHandler
 * @package Cms\DashParser\Entity
 */
class EntityImageHandler extends AbstractEntityHandler
{

    /**
     * @inheritdoc
     */
    protected function process($mapItem)
    {
        if (!$this->isValidEntity($mapItem, 'IMAGE')) {
            return null;
        }
        return new EntityImage(
            $mapItem['data']['url'],
            !empty($mapItem['data']['link']) ? $mapItem['data']['link'] : null,
            $mapItem['data']['width'],
            $mapItem['data']['height'],
            !empty($mapItem['data']['copyright']) ? $mapItem['data']['copyright'] : '',
            !empty($mapItem['data']['legend']) ? $mapItem['data']['legend'] : '',
            $mapItem['data']['position'],
            !empty($mapItem['data']['link_target']) ? $mapItem['data']['link_target'] : null,
            !empty($mapItem['data']['link_title']) ? $mapItem['data']['link_title'] : null,
            !empty($mapItem['data']['link_rel']) ? $mapItem['data']['link_rel'] : null
        );
    }
}
