<?php


namespace Cms\DashParser\Entity;

/**
 * Interface EntityLinkableInterface
 * @package Cms\DashParser\Entity
 */
interface EntityLinkableInterface extends EntityInterface
{

    /**
     * @return string
     */
    public function getLink();

    /**
     * @return string
     */
    public function getLinkTarget();

    /**
     * @return string
     */
    public function getLinkTitle();

    /**
     * @return string
     */
    public function getLinkRel();

    /**
     * @param string $link
     * @param null|string $linkTarget
     * @return $this
     */
    public function setLink($link, $linkTarget = '_self');
}
