<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityPositionableTrait
 * @package Cms\DashParser\Entity
 */
trait EntityPositionableTrait
{

    /** @var  string */
    protected $position;

    /**
     * @return string
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * @param string|EntityPositionEnum $position
     * @return $this
     */
    public function setPosition($position)
    {
        if (!EntityPositionEnum::isValid($position)) {
            throw new \InvalidArgumentException("invalid position ($position)");
        }
        $this->position = $position;

        return $this;
    }
}
