<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityEmbed;
use Cms\DashParser\Entity\EntityInterface;

/**
 * Class HtmlEntityEmbedConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityEmbedConverter implements HtmlEntityConverterInterface
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityEmbed) {
            return null;
        }

        // on vide le contenu
        $iframeNode = $doc->createElement('iframe');
        $iframeNode->setAttribute('src', $entity->getUrl());
        $iframeNode->setAttribute('width', "100%");
        $iframeNode->setAttribute('frameborder', "0");
        $iframeNode->setAttribute('allowfullscreen', true);
        return $iframeNode;
    }
}
