<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityImage;
use Cms\DashParser\Entity\EntityInterface;

/**
 * Class HtmlEntityImageConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityImageConverter implements HtmlEntityConverterInterface
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityImage) {
            return null;
        }

        // on vide le contenu
        $imgNode = $doc->createElement('img');
        $imgNode->setAttribute('alt', $entity->getLegend() ?: $nodeText);
        $imgNode->setAttribute('src', $entity->getSrc());
        if ($entity->getWidth()) {
            $imgNode->setAttribute('width', $entity->getWidth());
        }
        if ($entity->getHeight()) {
            $imgNode->setAttribute('height', $entity->getHeight());
        }
        return $imgNode;
    }
}
