<?php

namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityInterface;
use Cms\DashParser\Entity\EntityLink;

/**
 * Class HtmlEntityLinkConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityLinkConverter implements HtmlEntityConverterInterface
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param string $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityLink) {
            return null;
        }

        // gestion des noeud liens
        $nodeLink = $entity->getLink();
        if (!empty($nodeLink)) {
            $node = $doc->createElement('a');
            $node->setAttribute("title", $entity->getLinkTitle() ?: $nodeText);
            $node->setAttribute("href", $nodeLink);
            if (($linkRel = $entity->getLinkRel())) {
                $node->setAttribute("rel", $linkRel);
            }
            if (($linkTarget = $entity->getLinkTarget()) && $linkTarget !== '_self') {
                $node->setAttribute("target", $linkTarget);
            }
            return $node;
        }
        return null;
    }
}
