<?php
require_once __DIR__ . '/../vendor/autoload.php';

$logger = new \Monolog\Logger("dash-parser");
$logger->pushHandler(
    new \Monolog\Handler\StreamHandler(
        'php://stderr',
        \Monolog\Logger::WARNING
    )
);

$jsonContent1 = <<<EOF
{"blocks":[{"key":"erkng","text":"Cat\u00e9gorie tr\u00e8s tendance en ce moment, le segment des petits SUV compte un absent de marque: Volkswagen. Mais nos photos espions prouvent que la marque allemande travaille activement \u00e0 r\u00e9parer cette lacune. On y d\u00e9couvre en effet un baroudeur au format bien plus compact que celui du Tiguan. Seul \u00e9l\u00e9ment bien visible \u00e0 travers l'important camouflage, la signature lumineuse des feux arri\u00e8re \u00e9voque d'ailleurs ce grand fr\u00e8re. Mais les lignes de ce SUV d\u00e9riv\u00e9 de la future Polo s'inspireront aussi du concept T-Cross Breeze du dernier salon de Gen\u00e8ve... m\u00eame s'il faudra faire l'impasse sur la possibilit\u00e9 de rouler \u00e0 ciel ouvert.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":206,"length":83,"style":"BOLD"},{"offset":552,"length":75,"style":"BOLD"}],"entityRanges":[{"offset":283,"length":6,"key":0},{"offset":464,"length":11,"key":1},{"offset":507,"length":14,"key":2}]},{"key":"15v6b","text":"Transmission int\u00e9grale sur les versions hautes","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"6vbat","text":"Avec ses 4,15 m de long environ, ce Volkswagen au nom encore myst\u00e9rieux viendra rivaliser avec les Renault Captur, Peugeot 2008 et autres Nissan Juke. Essentiellement propos\u00e9 en version deux roues motrices, il pourra aussi recevoir une transmission int\u00e9grale sur certaines motorisations, contrairement \u00e0 ses rivaux fran\u00e7ais. Pour ce faire, il reposera sur une \u00e9volution de la plate-forme MQB d\u00e9di\u00e9e sp\u00e9cialement aux petits mod\u00e8les. Quant \u00e0 la palette des motorisations, elle comprendra notamment le r\u00e9cent trois-cylindres 1.0 turbo-essence TSI de 110 ch, qui avait \u00e9t\u00e9 choisi par le concept T-Cross.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":207,"length":51,"style":"BOLD"},{"offset":340,"length":90,"style":"BOLD"}],"entityRanges":[{"offset":107,"length":6,"key":3},{"offset":123,"length":4,"key":4},{"offset":145,"length":4,"key":5}]},{"key":"3f6bv","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"72jht","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":6}]},{"key":"fbinl","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/volkswagen\/tiguan","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/14859-premieres-photos-pour-la-future-polo","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/actualites\/volkswagen\/volkswagen_t_cross_breeze","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/renault\/captur","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/peugeot\/2008","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/nissan\/juke","url_target":"_self"}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/2497\/config\/2454","link":"","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"automobile-magazine.fr","legend":"La prochaine g\u00e9n\u00e9ration de Polo sera accompagn\u00e9 d'un d\u00e9riv\u00e9\u00a8SUV, nettement plus ambitieux que l'actuelle CrossPolo qui n'est qu'une simple berline rehauss\u00e9e.","position":"full"}}],"html":null}
EOF;

$jsonContent2 = <<<EOF
{"blocks":[{"key":"d3ld8","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"50rpr","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":0}]},{"key":"dsafr","text":"Dix ans apr\u00e8s les d\u00e9buts de Renault dans le low-cost, avec Dacia et la Logan, le petit crossover Kwid, vendu \u00e0 partir de 265\u00a0000 roupies en Inde (3\u00a0800 \u20ac), est un succ\u00e8s (plus de 100\u00a0000 ventes en 2016). Le secret de la r\u00e9ussite\u00a0? \" D'autres marques savent faire du low-cost, pr\u00e9cise G\u00e9rard D\u00e9tourbet, \u00e0 la t\u00eate de l'Unit\u00e9 de D\u00e9veloppement du segment A de Renault-Nissan (moins de 3,70 m de long). En Inde, il y a d\u2019abord Suzuki bien s\u00fbr (avec sa marque locale Maruti, dont le duo Swift et d\u00e9riv\u00e9 4-portes Dzire s\u2019est \u00e9coul\u00e9 \u00e0 450\u00a0000 exemplaires l\u2019an pass\u00e9), ou encore Hyundai. En Asie du Sud-Est, on peut aussi citer Daihatsu. Mais leur offre \u00e0 bas co\u00fbt n\u2019est pas mondiale. Et puis, notre Kwid est probablement plus original dans sa d\u00e9marche. Outre nos dix ann\u00e9es d'exp\u00e9rience avec Dacia, nous avons tout de suite imagin\u00e9 une plate-forme mondiale, \u00e0 partir d\u2019une feuille blanche. N\u2019'oublions pas non plus le design, qui devait absolument \u00eatre s\u00e9duisant. \"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":231,"length":167,"style":"BOLD"},{"offset":676,"length":205,"style":"BOLD"},{"offset":398,"length":559,"style":"ITALIC"}],"entityRanges":[{"offset":71,"length":5,"key":1},{"offset":81,"length":20,"key":2},{"offset":481,"length":5,"key":3}]},{"key":"juc","text":"\" La premi\u00e8re r\u00e9flexion que j\u2019ai entendue de la part des journalistes indiens, lorsqu\u2019ils ont vu le Kwid, c\u2019\u00e9tait : c\u2019est un mod\u00e8le premium ! \"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":0,"length":143,"style":"ITALIC"}],"entityRanges":[]},{"key":"2mt30","text":"Pour autant, Renault n\u2019est pas le premier \u00e0 frapper fort dans les voitures \u00e0 tr\u00e8s bas co\u00fbt. Tata, toujours en Inde, qui s\u2019\u00e9tait ainsi lanc\u00e9 dans l\u2019aventure avec la Nano en 2008, a essuy\u00e9 un \u00e9chec cuisant. \"\u00a0Oui, mais hormis l\u2019excellente habitabilit\u00e9 de cette voiture \u2013 on tient \u00e0 cinq adultes dans 3,16 m \u2013, la Nano avait des d\u00e9fauts, analyse G\u00e9rard D\u00e9tourbet. Le premier, c\u2019\u00e9tait le moteur arri\u00e8re\u00a0: une caract\u00e9ristique r\u00e9dhibitoire pour les Indiens, qui l\u2019ont aussit\u00f4t assimil\u00e9e \u00e0 un rickshaw \u00e0 quatre roues. Et puis, il y a eu le discours de Ratan Tata, le patron de la marque, qui parlait sans cesse de \"voiture pour les pauvre\". Or, quand vous pouvez enfin vous offrir une automobile, ce n\u2019est pas pour entendre que vous \u00eates pauvre\u00a0! Ce sont de grosses erreurs de marketing.\u00a0\" ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":204,"length":1,"style":"BOLD"},{"offset":206,"length":154,"style":"BOLD"},{"offset":634,"length":149,"style":"BOLD"},{"offset":205,"length":128,"style":"ITALIC"},{"offset":361,"length":421,"style":"ITALIC"}],"entityRanges":[{"offset":164,"length":4,"key":4}]},{"key":"famos","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":5}]},{"key":"ddtvc","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"14khb","text":"Par ailleurs, avec la g\u00e9n\u00e9ralisation du cr\u00e9dit automobile, le c\u00f4t\u00e9 prix minimal est devenu moins fondamental. \"L\u2019acqu\u00e9reur ach\u00e8te une fiert\u00e9. Il ne montre pas seulement son propre statut, mais celui de sa famille, de son clan. La premi\u00e8re r\u00e9flexion que j\u2019ai entendue de la part des journalistes indiens, lorsqu\u2019ils ont vu le Kwid, c\u2019\u00e9tait\u00a0: c\u2019est un mod\u00e8le premium\u00a0!\u00a0\"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":110,"length":258,"style":"ITALIC"},{"offset":110,"length":116,"style":"BOLD"}],"entityRanges":[]},{"key":"9f0t3","text":"Dommage, il n\u2019est plus vraiment question de faire venir ce petit SUV, dont la bonne bouille vous aurait s\u00fbrement fait craquer, jusqu\u2019en Europe. \"Pour \u00eatre rentable sur un march\u00e9, un mod\u00e8le \u00e0 ce prix \u2013 nous aurions pu vendre le Kwid autour de 6\u00a0000 \u20ac en Europe \u2013 doit s\u2019\u00e9couler \u00e0 au moins 150\u00a0000 exemplaires. Je ne suis pas s\u00fbr que nous atteindrions ces volumes sur notre continent\". Ce sera donc le Br\u00e9sil qui sera le premier servi apr\u00e8s l\u2019Inde, suivi par d\u2019autres pays\u2026 et d\u2019autres carrosseries, bas\u00e9es sur la m\u00eame plate-forme. Laquelle a donc \u00e9t\u00e9 d\u00e9velopp\u00e9e pour s\u2019adapter \u00e0 toutes les demandes, et \u00e0 toutes les normes. ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":143,"length":239,"style":"ITALIC"},{"offset":144,"length":239,"style":"BOLD"}],"entityRanges":[]},{"key":"45u8r","text":"\" Nos efforts sur la s\u00e9curit\u00e9 passive en Inde ? On n'en a tir\u00e9 aucun b\u00e9n\u00e9fice ! \"","type":"blockquote","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"9klac","text":"\"Pour l\u2019Inde par exemple, nous avons respect\u00e9 les normes locales de s\u00e9curit\u00e9 passive, se rappelle G\u00e9rard D\u00e9tourbet. Lesquelles sont extr\u00eamement basiques. Puis, nous avons appris que l\u2019organisme NCAP, qui effectue les crash-tests en Europe, allait se pencher sur le cas des voitures indiennes. Alors, six mois avant le lancement, nous avons d\u00e9cid\u00e9 de d\u00e9crocher 3 \u00e9toiles au crash-test, ce qui serait une tr\u00e8s bonne performance pour une voiture indienne. On a modifi\u00e9 pas mal de choses pour y parvenir. Eh bien devinez quoi\u00a0? On n\u2019en a tir\u00e9 aucun b\u00e9n\u00e9fice. M\u00eame pas pour notre image. Et ce, malgr\u00e9 la mortalit\u00e9 routi\u00e8re du pays, qui d\u00e9cime plus de 100\u00a0000 personnes par an. Nous proposons l\u2019airbag \u00e0 prix co\u00fbtant sur le Kwid. Et pourtant, nous n\u2019atteignons m\u00eame pas 50 % des ventes avec ne serait-ce qu\u2019un seul coussin gonflable\u2026\u00a0\" ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":0,"length":85,"style":"ITALIC"},{"offset":116,"length":714,"style":"ITALIC"},{"offset":293,"length":159,"style":"BOLD"},{"offset":672,"length":158,"style":"BOLD"}],"entityRanges":[{"offset":184,"length":15,"key":6}]},{"key":"bjglf","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":7}]},{"key":"4oi5h","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/225x300\/87351\/config\/69214","width":225,"height":300,"target":"_self","ratio":"portrait","size":"petit","copyright":"Renault","legend":"G\u00e9rard D\u00e9tourbet est \u00e0 la t\u00eate de l'Unit\u00e9 de D\u00e9veloppement du segment A de Renault-Nissan (moins de 3,70 m de long).","position":"left"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/dacia\/logan","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":71,"focusKey":"d3ld8","focusOffset":76,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/934-actualites-renault-renault-kwid2","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":81,"focusKey":"d3ld8","focusOffset":101,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/tous-les-essais\/article\/18430-essai-suzuki-swift-2017-le-poids-de-lenjeu-avec-video","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":481,"focusKey":"d3ld8","focusOffset":486,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/14095-actualites-tata-tata-nano","target":"_self","select":{"anchorKey":"2mt30","anchorOffset":164,"focusKey":"2mt30","focusOffset":168,"isBackward":false,"hasFocus":false}}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/17444\/config\/16208","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"Renault","legend":"Longue de 3,68 m, la citadine est gentiment SUV-is\u00e9e, avec une garde au sol de\u00a018\u00a0cm et des protections en plastique.","position":"full"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/crash-tests-euro-ncap","target":"_self","select":{"anchorKey":"9klac","anchorOffset":184,"focusKey":"9klac","focusOffset":199,"isBackward":false,"hasFocus":false}}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/17439\/config\/16203","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"Renault","legend":"Son prix bas contraste avec un \u00e9quipement plut\u00f4t moderne. Interface Bluetooth, climatisation\u2026","position":"full"}}],"html":null}
EOF;

$jsonContent3 = <<<EOF
{"blocks":[{"key":"ffad8","text":"Le premier SUV DS pr\u00e9vu pour l'Europe n'aura finalement pas attendu sa pr\u00e9sentation officielle au salon de Gen\u00e8ve pour enlever ses camouflages : Frank, un photographe amateur, a d'abord eu le bon r\u00e9flexe en croisant un exemplaire de cette nouveaut\u00e9 tr\u00e8s attendue, sans le moindre d\u00e9guisement, et en publiant son clich\u00e9 sur Twitter. Tandis qu'aujourd'hui, deux nouvelles images publi\u00e9es sur le forum sp\u00e9cialis\u00e9 Worldscoop ont notamment permis de d\u00e9couvrir la poupe. Suffisant pour confirmer nos informations, puisqu'on a d\u00e9couvert un faci\u00e8s tr\u00e8s proche de celui de notre illustration exclusive : la rang\u00e9e de diodes fa\u00e7on DS 3 dans le bouclier, le capot bien plat ou encore les \"sabres\" chrom\u00e9s qui d\u00e9marrent sous les phares et se prolongent jusqu'\u00e0 une grande calandre sont bel et bien l\u00e0.\u00a0Quant \u00e0 la poupe, comme pr\u00e9vu, elle a droit \u00e0 un grand hayon et \u00e0 de minces optiques.  ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":152,"length":139,"style":"BOLD"},{"offset":596,"length":193,"style":"BOLD"}],"entityRanges":[{"offset":107,"length":6,"key":0},{"offset":145,"length":5,"key":1},{"offset":410,"length":10,"key":2},{"offset":621,"length":4,"key":3}]},{"key":"2lv98","text":"Des technologies in\u00e9dites \u00e0 ce niveau de gamme","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"2vd01","text":"La plaque d'immatriculation du tout premier clich\u00e9 confirme, elle, l'appellation DS 7 Crossback que nous vous avions d\u00e9j\u00e0 annonc\u00e9e. Ce SUV viendra donc se placer au sommet de la gamme du jeune constructeur \"premium\" fran\u00e7ais. D'un format encore raisonnable, il d\u00e9rivera \u00e9troitement du tr\u00e8s r\u00e9ussi 3008 de Peugeot. Mais il s'en distinguera par une technologie in\u00e9dite \u00e0 ce niveau de tarif : une suspension pneumatique associ\u00e9 \u00e0 une cam\u00e9ra afin d'adapter de mani\u00e8re anticip\u00e9e le confort et le comportement au profil de la route. Comme l'a r\u00e9v\u00e9l\u00e9 un autre adepte de Twitter, Yves Bonnefont, le patron de la marque, une fonction de conduite autonome assez pouss\u00e9e figurera \u00e9galement au programme. En attendant une version hybride rechargeable pr\u00e9vue pour 2019, qui viendra dans le m\u00eame temps compenser l'une des lacunes de ce DS 7 Crossback face \u00e0 ses concurrents Mercedes, Audi et BMW : gr\u00e2ce \u00e0 son moteur \u00e9lectrique \u00e0 l'arri\u00e8re, associ\u00e9e \u00e0 un quatre-cylindres 1.6 turbo-essence, cette variante sera la seule \u00e0 proposer quatre roues motrices.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":390,"length":136,"style":"BOLD"},{"offset":693,"length":188,"style":"BOLD"}],"entityRanges":[{"offset":297,"length":4,"key":4},{"offset":718,"length":20,"key":5}]},{"key":"2uako","text":"<blockquote class=\"twitter-tweet\" data-lang=\"fr\"><p lang=\"fr\" dir=\"ltr\">Nouveau DS 7 Crossback aper\u00e7u sans camouflage \u00e0 la Defense le 9\/02 a 16h en avant premi\u00e8re <a href=\"https:\/\/twitter.com\/hashtag\/DS7?src=hash\">#DS7<\/a> <a href=\"https:\/\/twitter.com\/hashtag\/SCOOP?src=hash\">#SCOOP<\/a> <a href=\"https:\/\/twitter.com\/DS_fr\">@DS_fr<\/a> <a href=\"https:\/\/twitter.com\/automoto_TF1\">@automoto_TF1<\/a> <a href=\"https:\/\/twitter.com\/hashtag\/Geneve?src=hash\">#Geneve<\/a> <a href=\"https:\/\/t.co\/2sviqRL8RL\">pic.twitter.com\/2sviqRL8RL<\/a><\/p>&mdash; Frank (@Frncois_B) <a href=\"https:\/\/twitter.com\/Frncois_B\/status\/829832531352621056\">9 f\u00e9vrier 2017<\/a><\/blockquote>","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"f84u2","text":"<script async src=\"\/\/platform.twitter.com\/widgets.js\" charset=\"utf-8\"><\/script>","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/salons-auto\/4-salon-de-geneve","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"https:\/\/twitter.com\/Frncois_B","target":"_blank"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/worldscoop.forumpro.fr\/t6427p100-2018-ds-automobiles-ds-7-crossback-x74","target":"_blank"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/ds\/ds3","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/peugeot\/3008","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/405-actualites-scoops-peugeot-peugeot-3008-hybrid4-2019","target":"_self"}}],"html":null}
EOF;


// creation des handler par défault
$entityHandler = \Cms\DashParser\Entity\EntityHandlerFactory::createHandler();
$blockHandler = \Cms\DashParser\Block\BlockHandlerFactory::createHander();

foreach ([$jsonContent1, $jsonContent2, $jsonContent3] as $jsonContent) {
    // creation object
    $dashContent = json_decode($jsonContent, true);
    $content = new \Cms\DashParser\DashContent();
    $content->setBlocks($dashContent['blocks']);
    $content->setEntityMap($dashContent['entityMap']);

    // test parse ok
    if (!$content->getBlocks()) {
        throw new UnexpectedValueException('erreur de décodage : ');
    }

    // parse
    $dash = \Cms\DashParser\DashParser::parse($content, $entityHandler, $blockHandler);

    // serializer
    $serializer = new \Cms\DashParser\Serializer\HtmlSerializer($dash->getEntityCollection());
    $serializer->setLogger($logger);
    echo $serializer->serialize($dash->getBlocksCollection());
    echo "\n";
}