<?php

namespace Cms\DashParser\Block;

/**
 * Class BlockHeadlineHandler
 * @package Cms\DashParser\Block
 */
class BlockHeadlineHandler extends AbstractBlockHandler
{

    /** @var array */
    protected static $TEXT_TO_DIGIT = [
        'zero',
        'one',
        'two',
        'three',
        'four',
        'five',
        'six',
    ];

    /** @var  int */
    private static $HEADER_DIGIT_OFFSET = 1;

    /**
     * @inheritdoc
     */
    protected function process($blockData)
    {
        if ($this->isValidBlock($blockData) && substr($blockData['type'], 0, 6) === 'header') {
            list(, $level) = explode('-', $blockData['type']);
            $textToDigit = array_flip(self::$TEXT_TO_DIGIT);
            if (!isset($textToDigit[$level])) {
                $level = 6;
            } else {
                $level = $textToDigit[$level];
            }
            return new BlockHeadline($blockData['text'], max(
                1 + self::$HEADER_DIGIT_OFFSET,
                min($level + self::$HEADER_DIGIT_OFFSET, 6)
            ));
        }
        return null;
    }

    /**
     * @param int $offset
     * @throws \InvalidArgumentException
     */
    public static function setOffsetHeader($offset)
    {
        if (!is_numeric($offset)) {
            throw new \InvalidArgumentException('offset must be an int');
        }
        self::$HEADER_DIGIT_OFFSET = $offset;
    }
}
