<?php

namespace Cms\DashParser\Block;

/**
 * Class BlockParagraphHandler
 * @package Cms\DashParser\Block
 */
class BlockParagraphHandler extends AbstractBlockHandler
{

    /**
     * @inheritdoc
     */
    protected function process($blockData)
    {
        if ($this->isValidBlock($blockData, 'unstyled') && (
                (
                    isset($blockData['text'])
                    && trim($blockData['text'])
                ) || (
                    !empty($blockData['inlineStyleRanges'])
                    || !empty($blockData['entityRanges'])
                )
            )
        ) {
            return new BlockParagraph($blockData['text']);
        }
        return null;
    }
}
