<?php
require_once __DIR__ . '/../vendor/autoload.php';

$logger = new \Monolog\Logger("dash-parser");
$logger->pushHandler(
    new \Monolog\Handler\StreamHandler(
        'php://stderr',
        \Monolog\Logger::WARNING
    )
);

$jsonContent1 = <<<EOF
{"blocks":[{"key":"erkng","text":"Cat\u00e9gorie tr\u00e8s tendance en ce moment, le segment des petits SUV compte un absent de marque: Volkswagen. Mais nos photos espions prouvent que la marque allemande travaille activement \u00e0 r\u00e9parer cette lacune. On y d\u00e9couvre en effet un baroudeur au format bien plus compact que celui du Tiguan. Seul \u00e9l\u00e9ment bien visible \u00e0 travers l'important camouflage, la signature lumineuse des feux arri\u00e8re \u00e9voque d'ailleurs ce grand fr\u00e8re. Mais les lignes de ce SUV d\u00e9riv\u00e9 de la future Polo s'inspireront aussi du concept T-Cross Breeze du dernier salon de Gen\u00e8ve... m\u00eame s'il faudra faire l'impasse sur la possibilit\u00e9 de rouler \u00e0 ciel ouvert.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":206,"length":83,"style":"BOLD"},{"offset":552,"length":75,"style":"BOLD"}],"entityRanges":[{"offset":283,"length":6,"key":0},{"offset":464,"length":11,"key":1},{"offset":507,"length":14,"key":2}]},{"key":"15v6b","text":"Transmission int\u00e9grale sur les versions hautes","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"6vbat","text":"Avec ses 4,15 m de long environ, ce Volkswagen au nom encore myst\u00e9rieux viendra rivaliser avec les Renault Captur, Peugeot 2008 et autres Nissan Juke. Essentiellement propos\u00e9 en version deux roues motrices, il pourra aussi recevoir une transmission int\u00e9grale sur certaines motorisations, contrairement \u00e0 ses rivaux fran\u00e7ais. Pour ce faire, il reposera sur une \u00e9volution de la plate-forme MQB d\u00e9di\u00e9e sp\u00e9cialement aux petits mod\u00e8les. Quant \u00e0 la palette des motorisations, elle comprendra notamment le r\u00e9cent trois-cylindres 1.0 turbo-essence TSI de 110 ch, qui avait \u00e9t\u00e9 choisi par le concept T-Cross.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":207,"length":51,"style":"BOLD"},{"offset":340,"length":90,"style":"BOLD"}],"entityRanges":[{"offset":107,"length":6,"key":3},{"offset":123,"length":4,"key":4},{"offset":145,"length":4,"key":5}]},{"key":"3f6bv","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"72jht","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":6}]},{"key":"fbinl","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/volkswagen\/tiguan","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/14859-premieres-photos-pour-la-future-polo","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/actualites\/volkswagen\/volkswagen_t_cross_breeze","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/renault\/captur","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/peugeot\/2008","url_target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/nissan\/juke","url_target":"_self"}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/2497\/config\/2454","link":"","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"automobile-magazine.fr","legend":"La prochaine g\u00e9n\u00e9ration de Polo sera accompagn\u00e9 d'un d\u00e9riv\u00e9\u00a8SUV, nettement plus ambitieux que l'actuelle CrossPolo qui n'est qu'une simple berline rehauss\u00e9e.","position":"full"}}],"html":null}
EOF;

$jsonContent2 = <<<EOF
{"blocks":[{"key":"d3ld8","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"50rpr","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":0}]},{"key":"dsafr","text":"Dix ans apr\u00e8s les d\u00e9buts de Renault dans le low-cost, avec Dacia et la Logan, le petit crossover Kwid, vendu \u00e0 partir de 265\u00a0000 roupies en Inde (3\u00a0800 \u20ac), est un succ\u00e8s (plus de 100\u00a0000 ventes en 2016). Le secret de la r\u00e9ussite\u00a0? \" D'autres marques savent faire du low-cost, pr\u00e9cise G\u00e9rard D\u00e9tourbet, \u00e0 la t\u00eate de l'Unit\u00e9 de D\u00e9veloppement du segment A de Renault-Nissan (moins de 3,70 m de long). En Inde, il y a d\u2019abord Suzuki bien s\u00fbr (avec sa marque locale Maruti, dont le duo Swift et d\u00e9riv\u00e9 4-portes Dzire s\u2019est \u00e9coul\u00e9 \u00e0 450\u00a0000 exemplaires l\u2019an pass\u00e9), ou encore Hyundai. En Asie du Sud-Est, on peut aussi citer Daihatsu. Mais leur offre \u00e0 bas co\u00fbt n\u2019est pas mondiale. Et puis, notre Kwid est probablement plus original dans sa d\u00e9marche. Outre nos dix ann\u00e9es d'exp\u00e9rience avec Dacia, nous avons tout de suite imagin\u00e9 une plate-forme mondiale, \u00e0 partir d\u2019une feuille blanche. N\u2019'oublions pas non plus le design, qui devait absolument \u00eatre s\u00e9duisant. \"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":231,"length":167,"style":"BOLD"},{"offset":676,"length":205,"style":"BOLD"},{"offset":398,"length":559,"style":"ITALIC"}],"entityRanges":[{"offset":71,"length":5,"key":1},{"offset":81,"length":20,"key":2},{"offset":481,"length":5,"key":3}]},{"key":"juc","text":"\" La premi\u00e8re r\u00e9flexion que j\u2019ai entendue de la part des journalistes indiens, lorsqu\u2019ils ont vu le Kwid, c\u2019\u00e9tait : c\u2019est un mod\u00e8le premium ! \"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":0,"length":143,"style":"ITALIC"}],"entityRanges":[]},{"key":"2mt30","text":"Pour autant, Renault n\u2019est pas le premier \u00e0 frapper fort dans les voitures \u00e0 tr\u00e8s bas co\u00fbt. Tata, toujours en Inde, qui s\u2019\u00e9tait ainsi lanc\u00e9 dans l\u2019aventure avec la Nano en 2008, a essuy\u00e9 un \u00e9chec cuisant. \"\u00a0Oui, mais hormis l\u2019excellente habitabilit\u00e9 de cette voiture \u2013 on tient \u00e0 cinq adultes dans 3,16 m \u2013, la Nano avait des d\u00e9fauts, analyse G\u00e9rard D\u00e9tourbet. Le premier, c\u2019\u00e9tait le moteur arri\u00e8re\u00a0: une caract\u00e9ristique r\u00e9dhibitoire pour les Indiens, qui l\u2019ont aussit\u00f4t assimil\u00e9e \u00e0 un rickshaw \u00e0 quatre roues. Et puis, il y a eu le discours de Ratan Tata, le patron de la marque, qui parlait sans cesse de \"voiture pour les pauvre\". Or, quand vous pouvez enfin vous offrir une automobile, ce n\u2019est pas pour entendre que vous \u00eates pauvre\u00a0! Ce sont de grosses erreurs de marketing.\u00a0\" ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":204,"length":1,"style":"BOLD"},{"offset":206,"length":154,"style":"BOLD"},{"offset":634,"length":149,"style":"BOLD"},{"offset":205,"length":128,"style":"ITALIC"},{"offset":361,"length":421,"style":"ITALIC"}],"entityRanges":[{"offset":164,"length":4,"key":4}]},{"key":"famos","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":5}]},{"key":"ddtvc","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"14khb","text":"Par ailleurs, avec la g\u00e9n\u00e9ralisation du cr\u00e9dit automobile, le c\u00f4t\u00e9 prix minimal est devenu moins fondamental. \"L\u2019acqu\u00e9reur ach\u00e8te une fiert\u00e9. Il ne montre pas seulement son propre statut, mais celui de sa famille, de son clan. La premi\u00e8re r\u00e9flexion que j\u2019ai entendue de la part des journalistes indiens, lorsqu\u2019ils ont vu le Kwid, c\u2019\u00e9tait\u00a0: c\u2019est un mod\u00e8le premium\u00a0!\u00a0\"","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":110,"length":258,"style":"ITALIC"},{"offset":110,"length":116,"style":"BOLD"}],"entityRanges":[]},{"key":"9f0t3","text":"Dommage, il n\u2019est plus vraiment question de faire venir ce petit SUV, dont la bonne bouille vous aurait s\u00fbrement fait craquer, jusqu\u2019en Europe. \"Pour \u00eatre rentable sur un march\u00e9, un mod\u00e8le \u00e0 ce prix \u2013 nous aurions pu vendre le Kwid autour de 6\u00a0000 \u20ac en Europe \u2013 doit s\u2019\u00e9couler \u00e0 au moins 150\u00a0000 exemplaires. Je ne suis pas s\u00fbr que nous atteindrions ces volumes sur notre continent\". Ce sera donc le Br\u00e9sil qui sera le premier servi apr\u00e8s l\u2019Inde, suivi par d\u2019autres pays\u2026 et d\u2019autres carrosseries, bas\u00e9es sur la m\u00eame plate-forme. Laquelle a donc \u00e9t\u00e9 d\u00e9velopp\u00e9e pour s\u2019adapter \u00e0 toutes les demandes, et \u00e0 toutes les normes. ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":143,"length":239,"style":"ITALIC"},{"offset":144,"length":239,"style":"BOLD"}],"entityRanges":[]},{"key":"45u8r","text":"\" Nos efforts sur la s\u00e9curit\u00e9 passive en Inde ? On n'en a tir\u00e9 aucun b\u00e9n\u00e9fice ! \"","type":"blockquote","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"9klac","text":"\"Pour l\u2019Inde par exemple, nous avons respect\u00e9 les normes locales de s\u00e9curit\u00e9 passive, se rappelle G\u00e9rard D\u00e9tourbet. Lesquelles sont extr\u00eamement basiques. Puis, nous avons appris que l\u2019organisme NCAP, qui effectue les crash-tests en Europe, allait se pencher sur le cas des voitures indiennes. Alors, six mois avant le lancement, nous avons d\u00e9cid\u00e9 de d\u00e9crocher 3 \u00e9toiles au crash-test, ce qui serait une tr\u00e8s bonne performance pour une voiture indienne. On a modifi\u00e9 pas mal de choses pour y parvenir. Eh bien devinez quoi\u00a0? On n\u2019en a tir\u00e9 aucun b\u00e9n\u00e9fice. M\u00eame pas pour notre image. Et ce, malgr\u00e9 la mortalit\u00e9 routi\u00e8re du pays, qui d\u00e9cime plus de 100\u00a0000 personnes par an. Nous proposons l\u2019airbag \u00e0 prix co\u00fbtant sur le Kwid. Et pourtant, nous n\u2019atteignons m\u00eame pas 50 % des ventes avec ne serait-ce qu\u2019un seul coussin gonflable\u2026\u00a0\" ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":0,"length":85,"style":"ITALIC"},{"offset":116,"length":714,"style":"ITALIC"},{"offset":293,"length":159,"style":"BOLD"},{"offset":672,"length":158,"style":"BOLD"}],"entityRanges":[{"offset":184,"length":15,"key":6}]},{"key":"bjglf","text":"image","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":7}]},{"key":"4oi5h","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/225x300\/87351\/config\/69214","width":225,"height":300,"target":"_self","ratio":"portrait","size":"petit","copyright":"Renault","legend":"G\u00e9rard D\u00e9tourbet est \u00e0 la t\u00eate de l'Unit\u00e9 de D\u00e9veloppement du segment A de Renault-Nissan (moins de 3,70 m de long).","position":"left"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/dacia\/logan","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":71,"focusKey":"d3ld8","focusOffset":76,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/934-actualites-renault-renault-kwid2","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":81,"focusKey":"d3ld8","focusOffset":101,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/tous-les-essais\/article\/18430-essai-suzuki-swift-2017-le-poids-de-lenjeu-avec-video","target":"_self","select":{"anchorKey":"d3ld8","anchorOffset":481,"focusKey":"d3ld8","focusOffset":486,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/14095-actualites-tata-tata-nano","target":"_self","select":{"anchorKey":"2mt30","anchorOffset":164,"focusKey":"2mt30","focusOffset":168,"isBackward":false,"hasFocus":false}}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/17444\/config\/16208","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"Renault","legend":"Longue de 3,68 m, la citadine est gentiment SUV-is\u00e9e, avec une garde au sol de\u00a018\u00a0cm et des protections en plastique.","position":"full"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/crash-tests-euro-ncap","target":"_self","select":{"anchorKey":"9klac","anchorOffset":184,"focusKey":"9klac","focusOffset":199,"isBackward":false,"hasFocus":false}}},{"type":"IMAGE","mutability":"MUTABLE","data":{"url":"\/asset\/cms\/1200x674\/17439\/config\/16203","width":1200,"height":674,"target":"_self","ratio":"16\/9","size":"grand","copyright":"Renault","legend":"Son prix bas contraste avec un \u00e9quipement plut\u00f4t moderne. Interface Bluetooth, climatisation\u2026","position":"full"}}],"html":null}
EOF;

$jsonContent3 = <<<EOF
{"blocks":[{"key":"ffad8","text":"Le premier SUV DS pr\u00e9vu pour l'Europe n'aura finalement pas attendu sa pr\u00e9sentation officielle au salon de Gen\u00e8ve pour enlever ses camouflages : Frank, un photographe amateur, a d'abord eu le bon r\u00e9flexe en croisant un exemplaire de cette nouveaut\u00e9 tr\u00e8s attendue, sans le moindre d\u00e9guisement, et en publiant son clich\u00e9 sur Twitter. Tandis qu'aujourd'hui, deux nouvelles images publi\u00e9es sur le forum sp\u00e9cialis\u00e9 Worldscoop ont notamment permis de d\u00e9couvrir la poupe. Suffisant pour confirmer nos informations, puisqu'on a d\u00e9couvert un faci\u00e8s tr\u00e8s proche de celui de notre illustration exclusive : la rang\u00e9e de diodes fa\u00e7on DS 3 dans le bouclier, le capot bien plat ou encore les \"sabres\" chrom\u00e9s qui d\u00e9marrent sous les phares et se prolongent jusqu'\u00e0 une grande calandre sont bel et bien l\u00e0.\u00a0Quant \u00e0 la poupe, comme pr\u00e9vu, elle a droit \u00e0 un grand hayon et \u00e0 de minces optiques.  ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":152,"length":139,"style":"BOLD"},{"offset":596,"length":193,"style":"BOLD"}],"entityRanges":[{"offset":107,"length":6,"key":0},{"offset":145,"length":5,"key":1},{"offset":410,"length":10,"key":2},{"offset":621,"length":4,"key":3}]},{"key":"2lv98","text":"Des technologies in\u00e9dites \u00e0 ce niveau de gamme","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"2vd01","text":"La plaque d'immatriculation du tout premier clich\u00e9 confirme, elle, l'appellation DS 7 Crossback que nous vous avions d\u00e9j\u00e0 annonc\u00e9e. Ce SUV viendra donc se placer au sommet de la gamme du jeune constructeur \"premium\" fran\u00e7ais. D'un format encore raisonnable, il d\u00e9rivera \u00e9troitement du tr\u00e8s r\u00e9ussi 3008 de Peugeot. Mais il s'en distinguera par une technologie in\u00e9dite \u00e0 ce niveau de tarif : une suspension pneumatique associ\u00e9 \u00e0 une cam\u00e9ra afin d'adapter de mani\u00e8re anticip\u00e9e le confort et le comportement au profil de la route. Comme l'a r\u00e9v\u00e9l\u00e9 un autre adepte de Twitter, Yves Bonnefont, le patron de la marque, une fonction de conduite autonome assez pouss\u00e9e figurera \u00e9galement au programme. En attendant une version hybride rechargeable pr\u00e9vue pour 2019, qui viendra dans le m\u00eame temps compenser l'une des lacunes de ce DS 7 Crossback face \u00e0 ses concurrents Mercedes, Audi et BMW : gr\u00e2ce \u00e0 son moteur \u00e9lectrique \u00e0 l'arri\u00e8re, associ\u00e9e \u00e0 un quatre-cylindres 1.6 turbo-essence, cette variante sera la seule \u00e0 proposer quatre roues motrices.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":390,"length":136,"style":"BOLD"},{"offset":693,"length":188,"style":"BOLD"}],"entityRanges":[{"offset":297,"length":4,"key":4},{"offset":718,"length":20,"key":5}]},{"key":"2uako","text":"<blockquote class=\"twitter-tweet\" data-lang=\"fr\"><p lang=\"fr\" dir=\"ltr\">Nouveau DS 7 Crossback aper\u00e7u sans camouflage \u00e0 la Defense le 9\/02 a 16h en avant premi\u00e8re <a href=\"https:\/\/twitter.com\/hashtag\/DS7?src=hash\">#DS7<\/a> <a href=\"https:\/\/twitter.com\/hashtag\/SCOOP?src=hash\">#SCOOP<\/a> <a href=\"https:\/\/twitter.com\/DS_fr\">@DS_fr<\/a> <a href=\"https:\/\/twitter.com\/automoto_TF1\">@automoto_TF1<\/a> <a href=\"https:\/\/twitter.com\/hashtag\/Geneve?src=hash\">#Geneve<\/a> <a href=\"https:\/\/t.co\/2sviqRL8RL\">pic.twitter.com\/2sviqRL8RL<\/a><\/p>&mdash; Frank (@Frncois_B) <a href=\"https:\/\/twitter.com\/Frncois_B\/status\/829832531352621056\">9 f\u00e9vrier 2017<\/a><\/blockquote>","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"f84u2","text":"<script async src=\"\/\/platform.twitter.com\/widgets.js\" charset=\"utf-8\"><\/script>","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/salons-auto\/4-salon-de-geneve","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"https:\/\/twitter.com\/Frncois_B","target":"_blank"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/worldscoop.forumpro.fr\/t6427p100-2018-ds-automobiles-ds-7-crossback-x74","target":"_blank"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/ds\/ds3","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/peugeot\/3008","target":"_self"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/405-actualites-scoops-peugeot-peugeot-3008-hybrid4-2019","target":"_self"}}],"html":null}
EOF;

$jsonContent4 = <<<EOF
{"blocks":[{"key":"6i3mk","text":"M\u00eame si Peugeot et DS font l'impasse, les nouveaut\u00e9s fran\u00e7aises ne seront pas absentes au salon de Francfort. Citro\u00ebn fera en effet le d\u00e9placement, avec son petit SUV C3 Aircross enfin en version de s\u00e9rie, tandis que la nouvelle Renault M\u00e9gane R.S. profitera de l'occasion pour enlever ses camouflages. Mais la v\u00e9ritable star pourrait bien \u00eatre roumaine, puisque la deuxi\u00e8me g\u00e9n\u00e9ration de Dacia Duster devrait faire ses d\u00e9buts outre-Rhin. Quant \u00e0 Opel, la marque allemande qui se pr\u00e9pare \u00e0 rejoindre le groupe PSA mettra en avant un mod\u00e8le fabriqu\u00e9 en France, \u00e0 Sochaux, le Grandland X, proche cousin technique du 3008, qui accompagnera le r\u00e9cent Crossland X, son petit fr\u00e8re con\u00e7u sur base de C3 Aircross, ainsi que la version baroudeuse Country Tourer de l'Insignia.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":110,"length":192,"style":"BOLD"},{"offset":439,"length":179,"style":"BOLD"}],"entityRanges":[{"offset":90,"length":18,"key":0},{"offset":220,"length":28,"key":1},{"offset":366,"length":35,"key":2}]},{"key":"adk3d","text":"La nouvelle Volkswagen Polo et le petit SUV T-Roc au rendez-vous","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"d85h3","text":"\u00c0 Francfort, forc\u00e9ment, les constructeurs locaux sont chez eux, au point d'occuper parfois des halls entiers. Avec en vedette, chez Volkswagen, deux mod\u00e8les qui devraient rapidement figurer parmi les meilleures ventes du constructeur : la nouvelle g\u00e9n\u00e9ration de la citadine Polo et le T-Roc, un petit SUV in\u00e9dit. Ce dernier sera d'ailleurs accompagn\u00e9 de l'Arona, son \u00e9quivalent chez Seat, tandis que Skoda emm\u00e8ne dans ses valises un baroudeur un peu plus grand, le Karoq. Chez Audi, en revanche, on pr\u00e9f\u00e8re se concentrer cette fois sur les berlines et autres \"coup\u00e9s cinq-portes\", avec la derni\u00e8re mouture de la limousine A8 et l'A7 Sportback deuxi\u00e8me du nom, ainsi qu'une probable \u00e9tude annon\u00e7ant la future A6. Bentley, Lamborghini et Porsche ne sont pas en reste, en exposant respectivement la nouvelle Continental GT, la version de s\u00e9rie du concept Urus et le Cayenne 3.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":109,"length":126,"style":"BOLD"},{"offset":472,"length":186,"style":"BOLD"}],"entityRanges":[{"offset":265,"length":13,"key":3},{"offset":356,"length":5,"key":4},{"offset":465,"length":5,"key":5}]},{"key":"79vls","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"58jqs","text":"embed","type":"atomic","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":5,"key":6}]},{"key":"4vde4","text":"","type":"unstyled","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"8o218","text":"Pour BMW, le programme est \u00e9galement charg\u00e9. Si la prochaine S\u00e9rie 3 devrait finalement attendre 2018 pour se montrer, on d\u00e9couvrira en effet un X3 totalement renouvel\u00e9, une S\u00e9rie 6 GT charg\u00e9e de prendre la suite de la mal aim\u00e9e S\u00e9rie 5 GT, une M5 convertie \u00e0 la transmission int\u00e9grale ou un restylage du monospace S\u00e9rie 2 Active Tourer et de la citadine i3. Membre du m\u00eame groupe, Rolls-Royce jouera la carte du tr\u00e8s grand luxe avec sa Phantom VIII, alors que Mini devrait r\u00e9v\u00e9ler son premier mod\u00e8le \u00e9lectrique de s\u00e9rie. Chez Mercedes, les derni\u00e8res rumeurs annoncent \u00e9galement la pr\u00e9sence d'un mod\u00e8le branch\u00e9, qui pourrait prendre le nom d'EQ-A et pr\u00e9figurer une future compacte \u00e9lectrique. Mais il faut aussi s'attendre \u00e0 d\u00e9couvrir une compacte plus classique, la nouvelle Classe A, accompagn\u00e9e du pick-up Classe X et de l'exub\u00e9rante hypercar AMG Project One \u00e9troitement d\u00e9riv\u00e9e de la F1.","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":44,"length":241,"style":"BOLD"},{"offset":522,"length":170,"style":"BOLD"}],"entityRanges":[{"offset":174,"length":10,"key":7},{"offset":245,"length":40,"key":8},{"offset":767,"length":17,"key":9}]},{"key":"b7f72","text":"Gros programme pour Kia et Hyundai","type":"header-one","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"dgqvh","text":"Difficile d'exister face \u00e0 de tels poids lourds, et de nombreux constructeurs \u00e9trangers ont pr\u00e9f\u00e9r\u00e9 s'absenter, comme Volvo ou Nissan. Jaguar n'a en revanche pas refus\u00e9 la confrontation, histoire de montrer son break XF Sportbrake ou son SUV \u00e9lectrique I-Pace en version de s\u00e9rie. Bien implant\u00e9 en Allemagne, Ford devrait d\u00e9voiler sa nouvelle Focus. Quant au groupe Hyundai-Kia, il frappe assez fort avec ses deux premiers SUV \u00e0 vocation europ\u00e9enne, les Kona et Stonic, la troisi\u00e8me g\u00e9n\u00e9ration de Cee'd ou sa premi\u00e8re compacte vraiment sportive, l'i30 N d\u00e9velopp\u00e9e en partie au N\u00fcrburgring. Le salon de Francfort 2017, aussi appel\u00e9 IAA, se d\u00e9roule du 14 au 24 septembre prochain, avec des journ\u00e9es presse organis\u00e9es les 12 et 13 septembre : de nombreuses surprises vous attendent donc encore sur notre site d'ici l\u00e0. ","type":"unstyled","depth":0,"inlineStyleRanges":[{"offset":281,"length":68,"style":"BOLD"},{"offset":591,"length":150,"style":"BOLD"}],"entityRanges":[{"offset":334,"length":14,"key":10},{"offset":454,"length":4,"key":11},{"offset":462,"length":6,"key":12}]},{"key":"84tn9","text":"La liste des nouveaut\u00e9s","type":"header-two","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"com5s","text":"Audi A6 (concept)","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":17,"key":13}]},{"key":"5h2jp","text":"Audi A7 Sportback","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":17,"key":14}]},{"key":"e9d11","text":"Audi A8","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":7,"key":15}]},{"key":"argso","text":"Bentley Continental GT","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":22,"key":16}]},{"key":"df4hb","text":"BMW S\u00e9rie 2 Active Tourer restyl\u00e9e","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":34,"key":17}]},{"key":"f8qq4","text":"BMW M5","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":6,"key":18}]},{"key":"fsle6","text":"BMW X3","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":6,"key":19}]},{"key":"2osjj","text":"BMW S\u00e9rie 6 GT","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":14,"key":20}]},{"key":"180if","text":"BMW i3 restyl\u00e9e","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":15,"key":21}]},{"key":"cln5g","text":"Citro\u00ebn C3 Aircross","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":19,"key":22}]},{"key":"3piu1","text":"Dacia Duster 2","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":14,"key":23}]},{"key":"hlda","text":"Ford Focus 4","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":12,"key":24}]},{"key":"fant6","text":"Hyundai i30 N","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":13,"key":25}]},{"key":"3nd8u","text":"Hyundai Kona","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":12,"key":26}]},{"key":"3tjnn","text":"Jaguar I-Pace","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":13,"key":27}]},{"key":"fir3p","text":"Jaguar XF Sportbrake","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":20,"key":28}]},{"key":"6fat3","text":"Kia Stonic","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":10,"key":29}]},{"key":"cddtu","text":"Kia Cee'd","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":9,"key":30}]},{"key":"did5n","text":"Lamborghini Urus","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":16,"key":31}]},{"key":"1oj86","text":"Mercedes Classe A","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":17,"key":32}]},{"key":"8do9d","text":"Mercedes EQ-A (concept)","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"frhc","text":"Mercedes Classe X","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":17,"key":33}]},{"key":"71f2b","text":"Mercedes Classe S Coup\u00e9 restyl\u00e9e","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"2gfbm","text":"Mercedes-AMG Project One","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":24,"key":34}]},{"key":"a9c10","text":"Mini \u00e9lectrique","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[]},{"key":"fv9i5","text":"Opel Grandland X","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":16,"key":35}]},{"key":"454gj","text":"Opel Insignia Country Tourer","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":28,"key":36}]},{"key":"fqmdp","text":"Porche Cayenne 3","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":16,"key":37}]},{"key":"aic2s","text":"Renault M\u00e9gane RS","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":17,"key":38}]},{"key":"rbou","text":"Rolls-Royce Phantom 8","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":21,"key":39}]},{"key":"a8ou","text":"Seat Arona","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":10,"key":40}]},{"key":"1hr0n","text":"Skoda Karoq","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":11,"key":41}]},{"key":"7k543","text":"Volkswagen Polo","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":15,"key":42}]},{"key":"402a9","text":"Volkswagen T-Roc","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[{"offset":0,"length":16,"key":43}]},{"key":"f86nf","text":"Volkswagen Golf Sportsvan restyl\u00e9e","type":"unordered-list-item","depth":0,"inlineStyleRanges":[],"entityRanges":[]}],"entityMap":[{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/salons-auto\/3-salon-de-francfort","target":"_self","select":{"anchorKey":"6i3mk","anchorOffset":90,"focusKey":"6i3mk","focusOffset":108,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18820-premiere-sortie-officielle-pour-la-renault-megane-4-rs-au-grand-prix-de-monaco","target":"_self","select":{"anchorKey":"6i3mk","anchorOffset":240,"focusKey":"6i3mk","focusOffset":240,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18863-le-futur-dacia-duster-en-sortie","target":"_self","select":{"anchorKey":"6i3mk","anchorOffset":366,"focusKey":"6i3mk","focusOffset":401,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18738-future-volkswagen-polo-absence-de-camouflage-trompeuse","target":"_self","select":{"anchorKey":"d85h3","anchorOffset":265,"focusKey":"d85h3","focusOffset":278,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18758-le-petit-suv-seat-arona-allege-son-camouflage","target":"_self","select":{"anchorKey":"d85h3","anchorOffset":356,"focusKey":"d85h3","focusOffset":361,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18799-skoda-karoq-le-premier-vrai-suv-compact-de-la-marque","target":"_self","select":{"anchorKey":"d85h3","anchorOffset":465,"focusKey":"d85h3","focusOffset":470,"isBackward":false,"hasFocus":false}}},{"type":"EMBED","mutability":"MUTABLE","data":{"url":"https:\/\/www.youtube.com\/watch?v=0gmI_LsW_9g&list=PLzeJ7aj3P1R1Tc8bzEZkyyNTiSGqJtZjt&index=83"}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/17376-la-serie-5-gt-prepare-sa-mue-en-serie-6-gt","target":"_self","select":{"anchorKey":"8o218","anchorOffset":174,"focusKey":"8o218","focusOffset":184,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18765-bmw-m5-2017-une-transmission-integrale-desactivable","target":"_self","select":{"anchorKey":"8o218","anchorOffset":245,"focusKey":"8o218","focusOffset":285,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/14812-la-future-classe-a-se-montre","target":"_self","select":{"anchorKey":"8o218","anchorOffset":767,"focusKey":"8o218","focusOffset":784,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18630-la-ford-focus-2018-se-prepare","target":"_self","select":{"anchorKey":"dgqvh","anchorOffset":334,"focusKey":"dgqvh","focusOffset":348,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18491-hyundai-kona-le-petit-suv-coreen-sannonce","target":"_self","select":{"anchorKey":"dgqvh","anchorOffset":454,"focusKey":"dgqvh","focusOffset":458,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18917-kia-stonic-le-nom-du-petit-suv-coreen-confirme","target":"_self","select":{"anchorKey":"dgqvh","anchorOffset":462,"focusKey":"dgqvh","focusOffset":468,"isBackward":false,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18150-la-future-audi-a6-prise-en-photo","target":"_self","select":{"anchorKey":"com5s","anchorOffset":17,"focusKey":"com5s","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18181-la-nouvelle-audi-a7-debarque-des-2017","target":"_self","select":{"anchorKey":"com5s","anchorOffset":17,"focusKey":"com5s","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/419-actualites-scoops-audi-future-audi-a82","target":"_self","select":{"anchorKey":"7k1ev","anchorOffset":7,"focusKey":"7k1ev","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/15281-la-bentley-continental-gt-2017-se-confronte-au-ring","target":"_self","select":{"anchorKey":"argso","anchorOffset":22,"focusKey":"argso","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18493-bmw-serie-2-active-tourer-un-restylage-en-preparation","target":"_self","select":{"anchorKey":"df4hb","anchorOffset":34,"focusKey":"df4hb","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18765-bmw-m5-2017-une-transmission-integrale-desactivable","target":"_self","select":{"anchorKey":"f8qq4","anchorOffset":6,"focusKey":"f8qq4","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/17428-le-futur-bmw-x3-en-tenue-de-camouflage-allegee","target":"_self","select":{"anchorKey":"fsle6","anchorOffset":6,"focusKey":"fsle6","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/17376-la-serie-5-gt-prepare-sa-mue-en-serie-6-gt","target":"_self","select":{"anchorKey":"2osjj","anchorOffset":14,"focusKey":"2osjj","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/modele\/bmw\/i3","target":"_self","select":{"anchorKey":"180if","anchorOffset":15,"focusKey":"180if","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18089-le-c-aircross-concept-annonce-le-futur-suv-citroen-c3-aircross","target":"_self","select":{"anchorKey":"cln5g","anchorOffset":19,"focusKey":"cln5g","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18863-le-futur-dacia-duster-en-sortie","target":"_self","select":{"anchorKey":"3piu1","anchorOffset":14,"focusKey":"3piu1","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18630-la-ford-focus-2018-se-prepare","target":"_self","select":{"anchorKey":"hlda","anchorOffset":12,"focusKey":"hlda","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18554-la-hyundai-i30-n-sengage-en-course","target":"_self","select":{"anchorKey":"fant6","anchorOffset":13,"focusKey":"fant6","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18491-hyundai-kona-le-petit-suv-coreen-sannonce","target":"_self","select":{"anchorKey":"3nd8u","anchorOffset":12,"focusKey":"3nd8u","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/17381-jaguar-prepare-son-premier-suv-electrique-li-pace","target":"_self","select":{"anchorKey":"3tjnn","anchorOffset":13,"focusKey":"3tjnn","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18632-le-nouveau-break-jaguar-xf-sportbrake-lance-cet-ete","target":"_self","select":{"anchorKey":"fir3p","anchorOffset":20,"focusKey":"fir3p","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18917-kia-stonic-le-nom-du-petit-suv-coreen-confirme","target":"_self","select":{"anchorKey":"6fat3","anchorOffset":10,"focusKey":"6fat3","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/17420-sortie-tres-camouflee-pour-la-future-kia-ceed","target":"_self","select":{"anchorKey":"cddtu","anchorOffset":9,"focusKey":"cddtu","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18778-le-suv-lamborghini-urus-se-degourdit-les-roues","target":"_self","select":{"anchorKey":"did5n","anchorOffset":16,"focusKey":"did5n","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/14812-la-future-classe-a-se-montre","target":"_self","select":{"anchorKey":"1oj86","anchorOffset":17,"focusKey":"1oj86","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/15256-le-concept-mercedes-x-class-annonce-le-premier-pick-up-de-letoile","target":"_self","select":{"anchorKey":"frhc","anchorOffset":17,"focusKey":"frhc","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/17459-une-f1-de-route-en-preparation-chez-mercedes-amg","target":"_self","select":{"anchorKey":"2gfbm","anchorOffset":24,"focusKey":"2gfbm","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18583-opel-grandland-x-le-cousin-du-3008-se-devoile","target":"_self","select":{"anchorKey":"fv9i5","anchorOffset":16,"focusKey":"fv9i5","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18515-lopel-insignia-country-tourer-2017-se-devoile-deja","target":"_self","select":{"anchorKey":"454gj","anchorOffset":28,"focusKey":"454gj","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/14132-actualites-scoops-porsche-video-futur-porsche-cayenne","target":"_self","select":{"anchorKey":"fqmdp","anchorOffset":16,"focusKey":"fqmdp","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18820-premiere-sortie-officielle-pour-la-renault-megane-4-rs-au-grand-prix-de-monaco","target":"_self","select":{"anchorKey":"aic2s","anchorOffset":17,"focusKey":"aic2s","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18888-rolls-royce-phantom-une-exposition-historique-avant-larrivee-du-nouveau-modele","target":"_self","select":{"anchorKey":"a8ou","anchorOffset":0,"focusKey":"rbou","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18758-le-petit-suv-seat-arona-allege-son-camouflage","target":"_self","select":{"anchorKey":"a8ou","anchorOffset":10,"focusKey":"a8ou","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/toute-l-actualite\/article\/18799-skoda-karoq-le-premier-vrai-suv-compact-de-la-marque","target":"_self","select":{"anchorKey":"1hr0n","anchorOffset":11,"focusKey":"1hr0n","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/tous-les-essais\/article\/18599-premier-essai-volkswagen-polo-2018-tout-dune-golf","target":"_self","select":{"anchorKey":"7k543","anchorOffset":15,"focusKey":"7k543","focusOffset":0,"isBackward":true,"hasFocus":false}}},{"type":"LINK","mutability":"MUTABLE","data":{"url":"http:\/\/www.automobile-magazine.fr\/scoops\/article\/18437-le-suv-compact-volkswagen-t-roc-debarque-des-2017","target":"_self","select":{"anchorKey":"402a9","anchorOffset":16,"focusKey":"402a9","focusOffset":0,"isBackward":true,"hasFocus":false}}}],"html":null}
EOF;

// creation des handler par défault
$entityHandler = \Cms\DashParser\Entity\EntityHandlerFactory::createHandler();
$blockHandler = \Cms\DashParser\Block\BlockHandlerFactory::createHander();

foreach ([$jsonContent1, $jsonContent2, $jsonContent3, $jsonContent4] as $jsonContent) {
    // creation object
    $dashContent = json_decode($jsonContent, true);
    $content = new \Cms\DashParser\DashContent();
    $content->setBlocks($dashContent['blocks']);
    $content->setEntityMap($dashContent['entityMap']);

    // test parse ok
    if (!$content->getBlocks()) {
        throw new UnexpectedValueException('erreur de décodage : ');
    }

    // parse
    $dash = \Cms\DashParser\DashParser::parse($content, $entityHandler, $blockHandler);

    // serializer
    $serializer = new \Cms\DashParser\Serializer\HtmlSerializer($dash->getEntityCollection());
    $serializer->setLogger($logger);
    echo $serializer->serialize($dash->getBlocksCollection());
    echo "\n\n\n\n";
}