<?php

namespace Cms\DashParser\Block;

use Cms\DashParser\AbstractHandler;

/**
 * Class AbstractBlockHandler
 * @package Cms\DashParser\Block
 */
abstract class AbstractBlockHandler extends AbstractHandler
{

    /**
     * Check validity of block for type
     * @param array $mapItem
     * @param string $type
     * @return bool
     */
    final protected function isValidBlock($mapItem, $type = null) : bool
    {
        return \is_array($mapItem)
        && !empty($mapItem['type'])
        && (empty($type) || $mapItem['type'] === strtolower($type));
    }
}
