<?php


namespace Cms\DashParser\Serializer;

use Cms\DashParser\Entity\EntityDocument;
use Cms\DashParser\Entity\EntityInterface;

/**
 * Class HtmlEntityDocumentConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlEntityDocumentConverter implements HtmlEntityConverterInterface
{
    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param null $nodeText
     * @return \DOMElement
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if(!$entity instanceof EntityDocument){
            return null;
        }
        $fallbackTxt = <<<EOF
This browser does not support PDFs. Please download the PDF to view it: <a href="{$entity->getUrl()}">Download PDF</a>.
EOF;
        $fallbackNode = $doc->createElement('p', $fallbackTxt);
        // on vide le contenu
        $objectNode = $doc->createElement('object');
        $objectNode->setAttribute('data', $entity->getUrl());
        $objectNode->setAttribute('width', '100%');
        $objectNode->setAttribute('height', '100%');
        $objectNode->appendChild($fallbackNode);
        return $objectNode;
    }
}