<?php


namespace Cms\DashParser\Block;

/**
 * Class BlockBreaklineHandler
 * @package Cms\DashParser\Block
 */
class BlockBreaklineHandler extends AbstractBlockHandler
{

    /**
     * @inheritdoc
     */
    protected function process($blockData)
    {
        if ($this->isValidBlock($blockData, 'unstyled')
            && (
                !isset($blockData['text'])
                || !trim($blockData['text'])
            )
            && empty($blockData['inlineStyleRanges'])
            && empty($blockData['entityRanges'])
        ) {
            return new BlockBreakline();
        }
        return null;
    }
}
