<?php


namespace Cms\DashParser\Entity;

/**
 * Class EntityImage
 * @package Cms\DashParser\Entity
 */
class EntityImage implements
    EntityBlockInterface,
    EntityLinkableInterface,
    EntityPositionableInterface
{

    use EntityPositionableTrait;
    use EntityLinkableTrait;

    /**
     * @var string
     */
    private $src;

    /**
     * @var int
     */
    private $width;

    /**
     * @var int
     */
    private $height;

    /**
     * @var string
     */
    private $copy;

    /**
     * @var string
     */
    private $legend;

    /**
     * EntityImage constructor.
     * @param string $src
     * @param string $linkUrl
     * @param int $width
     * @param int $height
     * @param string $copy
     * @param string $legend
     * @param string|EntityPositionEnum $position
     * @param null|string $linkTarget
     * @param null|string $linkTitle
     * @param null|string $linkRel
     * @throws \InvalidArgumentException
     */
    public function __construct(
        $src,
        $linkUrl,
        $width,
        $height,
        $copy,
        $legend,
        $position,
        $linkTarget = null,
        $linkTitle = null,
        $linkRel = null
    ) {
        $this->src = $src;
        $this->width = $width;
        $this->height = $height;
        $this->copy = $copy;
        $this->legend = $legend;

        $this->setLink($linkUrl, $linkTarget);
        $this->setPosition($position);
    }

    /**
     * @return string
     */
    public function getLegend() : string
    {
        return $this->legend;
    }

    /**
     * @param string $legend
     * @return $this
     */
    public function setLegend($legend)
    {
        $this->legend = $legend;
        return $this;
    }

    /**
     * @return string
     */
    public function getCopy() : string
    {
        return $this->copy;
    }

    /**
     * @param string $copy
     * @return $this
     */
    public function setCopy($copy)
    {
        $this->copy = $copy;
        return $this;
    }

    /**
     * @return int
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @param int $height
     * @return $this
     */
    public function setHeight($height)
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @return int
     */
    public function getWidth()
    {
        return $this->width;
    }

    /**
     * @param int $width
     * @return $this
     */
    public function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return string
     */
    public function getSrc() : string
    {
        return $this->src;
    }

    /**
     * @param string $src
     * @return $this
     */
    public function setSrc($src)
    {
        $this->src = $src;
        return $this;
    }
}
