<?php


namespace Cms\DashParser\Block;

/**
 * Class BlockListItemHandler
 * @package Cms\DashParser\Block
 */
class BlockListItemHandler extends AbstractBlockHandler
{

    /**
     * @inheritdoc
     */
    protected function process($blockData)
    {
        if (isset($blockData['text'])) {
            if ($this->isValidBlock($blockData, 'unordered-list-item')) {
                return new BlockListItem($blockData['text'], false);
            }
            if ($this->isValidBlock($blockData, 'ordered-list-item')) {
                return new BlockListItem($blockData['text'], true);
            }
        }
        return null;
    }
}
