<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityResource
 * @package Cms\DashParser\Entity
 */
class EntityResource implements EntityBlockInterface
{

    /** @var string */
    private $ref;

    /** @var string */
    private $provider;

    /** @var string */
    private $type;

    /** @var null|string */
    private $label;

    /**
     * EntityResource constructor.
     * @param string $ref
     * @param string $provider
     * @param string $type
     * @param string $label
     */
    public function __construct($ref, $provider, $type, $label = null)
    {
        $this->ref = $ref;
        $this->provider = $provider;
        $this->type = (string)$type;
        $this->label = $label;
    }

    /**
     * @return string
     */
    public function getRef()
    {
        return $this->ref;
    }

    /**
     * @return string
     */
    public function getProvider()
    {
        return $this->provider;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return null|string
     */
    public function getLabel()
    {
        return $this->label;
    }
}
