<?php


namespace Cms\DashParser\Block;

/**
 * Class BlockRangesTrait
 * @package Cms\DashParser\Block
 */
trait BlockRangesTrait
{

    /** @var array */
    protected $entityRanges = [];

    /** @var array */
    protected $inlineStyleRanges = [];

    /**
     * @param array $entityRanges
     * @return $this
     */
    public function setEntityRanges(array $entityRanges = [])
    {
        $this->entityRanges = $entityRanges;
        return $this;
    }

    /**
     * @param array $inlineStyleRanges
     * @return $this
     */
    public function setInlineStyleRanges(array $inlineStyleRanges = [])
    {
        $this->inlineStyleRanges = $inlineStyleRanges;
        return $this;
    }

    /**
     * @return array
     */
    public function getInlineStyleRanges() : array
    {
        return $this->inlineStyleRanges;
    }

    /**
     * @return array
     */
    public function getEntityRanges() : array
    {
        return $this->entityRanges;
    }
}
