<?php

namespace Cms\DashParser\Serializer;

/**
 * Class HtmlStyleConverter
 * @package Cms\DashParser\Serializer
 */
class HtmlStyleConverter
{

    /**
     * @param string $inlineStyle
     * @param string $contentHtml
     * @return null|string
     */
    public function getStyleNodeName($inlineStyle, $contentHtml = '')
    {
        switch ($inlineStyle) {
            case 'BOLD':
                $balise = 'strong';
                break;
            case 'ITALIC':
                $balise = 'em';
                break;
            case 'UNDERLINE':
                $balise = 'u';
                break;
            case 'CODE':
                $balise = 'pre';
                break;
            default:
                return null;
                break;
        }
        return $balise;
    }
}
