<?php

namespace Cms\DashParser\Entity;

/**
 * Class EntityEmbed
 * @package Cms\DashParser\Entity
 */
class EntityEmbed implements
    EntityBlockInterface,
    EntitySizableInterface
{

    use EntitySizableTrait;

    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $thumbUrl;


    /**
     * EntityEmbed constructor.
     * @param string $url
     * @param string $thumbUrl
     * @param null|int $width
     * @param null|int $height
     */
    public function __construct($url, $thumbUrl, $width = null, $height = null)
    {
        $this->url = $url;
        $this->thumbUrl = $thumbUrl;

        $this->setWidth($width);
        $this->setHeight($height);
    }

    /**
     * @return string
     */
    public function getUrl() : string
    {
        return $this->url;
    }

    /**
     * @param string $url
     * @return $this
     */
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    /**
     * @return string
     */
    public function getThumbUrl() : string
    {
        return $this->thumbUrl;
    }

    /**
     * @param string $thumbUrl
     * @return $this
     */
    public function setThumbUrl($thumbUrl)
    {
        $this->thumbUrl = $thumbUrl;
        return $this;
    }
}
