<?php


namespace Cms\DashParser\Entity;

use Cms\DashParser\HandlerInterface;

/**
 * Class EntityHandlerFactory
 * @package Cms\DashParser\Entity
 */
class EntityHandlerFactory
{

    /**
     * @return HandlerInterface
     */
    public static function createHandler() : HandlerInterface
    {
        $handler = new EntityAlignHandler();
        $handler->setSuccessor(new EntityResourceHandler());
        $handler->setSuccessor(new EntityImageHandler());
        $handler->setSuccessor(new EntityLinkHandler());
        $handler->setSuccessor(new EntityEmbedHandler());
        $handler->setSuccessor(new EntityDocumentHandler());
        return $handler;
    }
}
